/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.BrokerSummary;

@SdkInternalApi
public class BrokerSummaryMarshaller {
    private static final MarshallingInfo<String> BROKERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerArn").build();
    private static final MarshallingInfo<String> BROKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerId").build();
    private static final MarshallingInfo<String> BROKERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerName").build();
    private static final MarshallingInfo<String> BROKERSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerState").build();
    private static final MarshallingInfo<String> DEPLOYMENTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentMode").build();
    private static final MarshallingInfo<String> HOSTINSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostInstanceType").build();
    private static final BrokerSummaryMarshaller INSTANCE = new BrokerSummaryMarshaller();

    public static BrokerSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BrokerSummary brokerSummary, ProtocolMarshaller protocolMarshaller) {
        if (brokerSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)brokerSummary.brokerArn(), BROKERARN_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.brokerId(), BROKERID_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.brokerName(), BROKERNAME_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.brokerStateString(), BROKERSTATE_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.deploymentModeString(), DEPLOYMENTMODE_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.hostInstanceType(), HOSTINSTANCETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

