/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.PendingLogs;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PendingLogsMarshaller {
    private static final MarshallingInfo<Boolean> AUDIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audit").isBinary(false).build();
    private static final MarshallingInfo<Boolean> GENERAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("general").isBinary(false).build();
    private static final PendingLogsMarshaller INSTANCE = new PendingLogsMarshaller();

    private PendingLogsMarshaller() {
    }

    public static PendingLogsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PendingLogs pendingLogs, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pendingLogs, (String)"pendingLogs");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pendingLogs.audit(), AUDIT_BINDING);
            protocolMarshaller.marshall((Object)pendingLogs.general(), GENERAL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

