/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mq.model.Logs;

public class LogsUnmarshaller
implements Unmarshaller<Logs, JsonUnmarshallerContext> {
    private static final LogsUnmarshaller INSTANCE = new LogsUnmarshaller();

    public Logs unmarshall(JsonUnmarshallerContext context) throws Exception {
        Logs.Builder logsBuilder = Logs.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("audit", targetDepth)) {
                    context.nextToken();
                    logsBuilder.audit((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("general", targetDepth)) {
                    context.nextToken();
                    logsBuilder.general((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Logs)logsBuilder.build();
    }

    public static LogsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

