/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mq.model.Configuration;
import software.amazon.awssdk.services.mq.transform.ConfigurationRevisionUnmarshaller;

public class ConfigurationUnmarshaller
implements Unmarshaller<Configuration, JsonUnmarshallerContext> {
    private static final ConfigurationUnmarshaller INSTANCE = new ConfigurationUnmarshaller();

    public Configuration unmarshall(JsonUnmarshallerContext context) throws Exception {
        Configuration.Builder configurationBuilder = Configuration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("created", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.created((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("engineType", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.engineType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("engineVersion", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.engineVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("latestRevision", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.latestRevision(ConfigurationRevisionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Configuration)configurationBuilder.build();
    }

    public static ConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

