/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.ConfigurationRevision;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationRevisionMarshaller {
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Integer> REVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").isBinary(false).build();
    private static final ConfigurationRevisionMarshaller INSTANCE = new ConfigurationRevisionMarshaller();

    private ConfigurationRevisionMarshaller() {
    }

    public static ConfigurationRevisionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigurationRevision configurationRevision, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configurationRevision, (String)"configurationRevision");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configurationRevision.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)configurationRevision.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)configurationRevision.revision(), REVISION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

