/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.services.mq.model.Logs;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrokerResponse
extends MqResponse
implements ToCopyableBuilder<Builder, UpdateBrokerResponse> {
    private final String brokerId;
    private final ConfigurationId configuration;
    private final Logs logs;

    private UpdateBrokerResponse(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.configuration = builder.configuration;
        this.logs = builder.logs;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public ConfigurationId configuration() {
        return this.configuration;
    }

    public Logs logs() {
        return this.logs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerResponse)) {
            return false;
        }
        UpdateBrokerResponse other = (UpdateBrokerResponse)((Object)obj);
        return Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.logs(), other.logs());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBrokerResponse").add("BrokerId", (Object)this.brokerId()).add("Configuration", (Object)this.configuration()).add("Logs", (Object)this.logs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private String brokerId;
        private ConfigurationId configuration;
        private Logs logs;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerResponse model) {
            super(model);
            this.brokerId(model.brokerId);
            this.configuration(model.configuration);
            this.logs(model.logs);
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final ConfigurationId.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ConfigurationId configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ConfigurationId.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final Logs.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        @Override
        public final Builder logs(Logs logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(Logs.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public UpdateBrokerResponse build() {
            return new UpdateBrokerResponse(this);
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    CopyableBuilder<Builder, UpdateBrokerResponse> {
        public Builder brokerId(String var1);

        public Builder configuration(ConfigurationId var1);

        default public Builder configuration(Consumer<ConfigurationId.Builder> configuration) {
            return this.configuration((ConfigurationId)((ConfigurationId.Builder)ConfigurationId.builder().applyMutation(configuration)).build());
        }

        public Builder logs(Logs var1);

        default public Builder logs(Consumer<Logs.Builder> logs) {
            return this.logs((Logs)((Logs.Builder)Logs.builder().applyMutation(logs)).build());
        }
    }
}

