/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.transform.PendingLogsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingLogs
implements StructuredPojo,
ToCopyableBuilder<Builder, PendingLogs> {
    private final Boolean audit;
    private final Boolean general;

    private PendingLogs(BuilderImpl builder) {
        this.audit = builder.audit;
        this.general = builder.general;
    }

    public Boolean audit() {
        return this.audit;
    }

    public Boolean general() {
        return this.general;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audit());
        hashCode = 31 * hashCode + Objects.hashCode(this.general());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingLogs)) {
            return false;
        }
        PendingLogs other = (PendingLogs)obj;
        return Objects.equals(this.audit(), other.audit()) && Objects.equals(this.general(), other.general());
    }

    public String toString() {
        return ToString.builder((String)"PendingLogs").add("Audit", (Object)this.audit()).add("General", (Object)this.general()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Audit": {
                return Optional.ofNullable(clazz.cast(this.audit()));
            }
            case "General": {
                return Optional.ofNullable(clazz.cast(this.general()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PendingLogsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean audit;
        private Boolean general;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingLogs model) {
            this.audit(model.audit);
            this.general(model.general);
        }

        public final Boolean getAudit() {
            return this.audit;
        }

        @Override
        public final Builder audit(Boolean audit) {
            this.audit = audit;
            return this;
        }

        public final void setAudit(Boolean audit) {
            this.audit = audit;
        }

        public final Boolean getGeneral() {
            return this.general;
        }

        @Override
        public final Builder general(Boolean general) {
            this.general = general;
            return this;
        }

        public final void setGeneral(Boolean general) {
            this.general = general;
        }

        public PendingLogs build() {
            return new PendingLogs(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PendingLogs> {
        public Builder audit(Boolean var1);

        public Builder general(Boolean var1);
    }
}

