/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.mq.model.MqRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationRevisionRequest
extends MqRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationRevisionRequest> {
    private final String configurationId;
    private final String configurationRevision;

    private DescribeConfigurationRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.configurationRevision = builder.configurationRevision;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public String configurationRevision() {
        return this.configurationRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationRevision());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRevisionRequest)) {
            return false;
        }
        DescribeConfigurationRevisionRequest other = (DescribeConfigurationRevisionRequest)((Object)obj);
        return Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.configurationRevision(), other.configurationRevision());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationRevisionRequest").add("ConfigurationId", (Object)this.configurationId()).add("ConfigurationRevision", (Object)this.configurationRevision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
            case "ConfigurationRevision": {
                return Optional.ofNullable(clazz.cast(this.configurationRevision()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MqRequest.BuilderImpl
    implements Builder {
        private String configurationId;
        private String configurationRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRevisionRequest model) {
            super(model);
            this.configurationId(model.configurationId);
            this.configurationRevision(model.configurationRevision);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final String getConfigurationRevision() {
            return this.configurationRevision;
        }

        @Override
        public final Builder configurationRevision(String configurationRevision) {
            this.configurationRevision = configurationRevision;
            return this;
        }

        public final void setConfigurationRevision(String configurationRevision) {
            this.configurationRevision = configurationRevision;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationRevisionRequest build() {
            return new DescribeConfigurationRevisionRequest(this);
        }
    }

    public static interface Builder
    extends MqRequest.Builder,
    CopyableBuilder<Builder, DescribeConfigurationRevisionRequest> {
        public Builder configurationId(String var1);

        public Builder configurationRevision(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

