/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.transform.ConfigurationRevisionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationRevision
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigurationRevision> {
    private final Instant created;
    private final String description;
    private final Integer revision;

    private ConfigurationRevision(BuilderImpl builder) {
        this.created = builder.created;
        this.description = builder.description;
        this.revision = builder.revision;
    }

    public Instant created() {
        return this.created;
    }

    public String description() {
        return this.description;
    }

    public Integer revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRevision)) {
            return false;
        }
        ConfigurationRevision other = (ConfigurationRevision)obj;
        return Objects.equals(this.created(), other.created()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.revision(), other.revision());
    }

    public String toString() {
        return ToString.builder((String)"ConfigurationRevision").add("Created", (Object)this.created()).add("Description", (Object)this.description()).add("Revision", (Object)this.revision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationRevisionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant created;
        private String description;
        private Integer revision;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRevision model) {
            this.created(model.created);
            this.description(model.description);
            this.revision(model.revision);
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        public ConfigurationRevision build() {
            return new ConfigurationRevision(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationRevision> {
        public Builder created(Instant var1);

        public Builder description(String var1);

        public Builder revision(Integer var1);
    }
}

