/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.services.mq.transform.BrokerInstanceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerInstance
implements StructuredPojo,
ToCopyableBuilder<Builder, BrokerInstance> {
    private final String consoleURL;
    private final List<String> endpoints;
    private final String ipAddress;

    private BrokerInstance(BuilderImpl builder) {
        this.consoleURL = builder.consoleURL;
        this.endpoints = builder.endpoints;
        this.ipAddress = builder.ipAddress;
    }

    public String consoleURL() {
        return this.consoleURL;
    }

    public List<String> endpoints() {
        return this.endpoints;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerInstance)) {
            return false;
        }
        BrokerInstance other = (BrokerInstance)obj;
        return Objects.equals(this.consoleURL(), other.consoleURL()) && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.ipAddress(), other.ipAddress());
    }

    public String toString() {
        return ToString.builder((String)"BrokerInstance").add("ConsoleURL", (Object)this.consoleURL()).add("Endpoints", this.endpoints()).add("IpAddress", (Object)this.ipAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsoleURL": {
                return Optional.ofNullable(clazz.cast(this.consoleURL()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BrokerInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String consoleURL;
        private List<String> endpoints = DefaultSdkAutoConstructList.getInstance();
        private String ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerInstance model) {
            this.consoleURL(model.consoleURL);
            this.endpoints(model.endpoints);
            this.ipAddress(model.ipAddress);
        }

        public final String getConsoleURL() {
            return this.consoleURL;
        }

        @Override
        public final Builder consoleURL(String consoleURL) {
            this.consoleURL = consoleURL;
            return this;
        }

        public final void setConsoleURL(String consoleURL) {
            this.consoleURL = consoleURL;
        }

        public final Collection<String> getEndpoints() {
            return this.endpoints;
        }

        @Override
        public final Builder endpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(String ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        public final void setEndpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public BrokerInstance build() {
            return new BrokerInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BrokerInstance> {
        public Builder consoleURL(String var1);

        public Builder endpoints(Collection<String> var1);

        public Builder endpoints(String ... var1);

        public Builder ipAddress(String var1);
    }
}

