/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.DeleteBrokerRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteBrokerRequestModelMarshaller {
    private static final MarshallingInfo<String> BROKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("broker-id").isBinary(false).build();
    private static final DeleteBrokerRequestModelMarshaller INSTANCE = new DeleteBrokerRequestModelMarshaller();

    private DeleteBrokerRequestModelMarshaller() {
    }

    public static DeleteBrokerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeleteBrokerRequest deleteBrokerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)deleteBrokerRequest), (String)"deleteBrokerRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deleteBrokerRequest.brokerId(), BROKERID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

