/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.ListOf__stringCopier;
import software.amazon.awssdk.services.mq.transform.UserMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements StructuredPojo,
ToCopyableBuilder<Builder, User> {
    private final Boolean consoleAccess;
    private final List<String> groups;
    private final String password;
    private final String username;

    private User(BuilderImpl builder) {
        this.consoleAccess = builder.consoleAccess;
        this.groups = builder.groups;
        this.password = builder.password;
        this.username = builder.username;
    }

    public Boolean consoleAccess() {
        return this.consoleAccess;
    }

    public List<String> groups() {
        return this.groups;
    }

    public String password() {
        return this.password;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.consoleAccess(), other.consoleAccess()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"User").add("ConsoleAccess", (Object)this.consoleAccess()).add("Groups", this.groups()).add("Password", (Object)this.password()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsoleAccess": {
                return Optional.ofNullable(clazz.cast(this.consoleAccess()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean consoleAccess;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private String password;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.consoleAccess(model.consoleAccess);
            this.groups(model.groups);
            this.password(model.password);
            this.username(model.username);
        }

        public final Boolean getConsoleAccess() {
            return this.consoleAccess;
        }

        @Override
        public final Builder consoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        public final void setConsoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ListOf__stringCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ListOf__stringCopier.copy(groups);
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public User build() {
            return new User(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, User> {
        public Builder consoleAccess(Boolean var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder password(String var1);

        public Builder username(String var1);
    }
}

