/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.ListOfUserSummaryCopier;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.services.mq.model.UserSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersResponse
extends MqResponse
implements ToCopyableBuilder<Builder, ListUsersResponse> {
    private final String brokerId;
    private final Integer maxResults;
    private final String nextToken;
    private final List<UserSummary> users;

    private ListUsersResponse(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.users = builder.users;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<UserSummary> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResponse)) {
            return false;
        }
        ListUsersResponse other = (ListUsersResponse)((Object)obj);
        return Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.users(), other.users());
    }

    public String toString() {
        return ToString.builder((String)"ListUsersResponse").add("BrokerId", (Object)this.brokerId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Users", this.users()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private String brokerId;
        private Integer maxResults;
        private String nextToken;
        private List<UserSummary> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersResponse model) {
            super(model);
            this.brokerId(model.brokerId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.users(model.users);
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<UserSummary.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(UserSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<UserSummary> users) {
            this.users = ListOfUserSummaryCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserSummary ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserSummary.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (UserSummary)((UserSummary.Builder)UserSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<UserSummary.BuilderImpl> users) {
            this.users = ListOfUserSummaryCopier.copyFromBuilder(users);
        }

        @Override
        public ListUsersResponse build() {
            return new ListUsersResponse(this);
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    CopyableBuilder<Builder, ListUsersResponse> {
        public Builder brokerId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder users(Collection<UserSummary> var1);

        public Builder users(UserSummary ... var1);

        public Builder users(Consumer<UserSummary.Builder> ... var1);
    }
}

