/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.MqRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigurationRequest
extends MqRequest
implements ToCopyableBuilder<Builder, CreateConfigurationRequest> {
    private final String engineType;
    private final String engineVersion;
    private final String name;

    private CreateConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.name = builder.name;
    }

    public EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public String engineTypeAsString() {
        return this.engineType;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationRequest)) {
            return false;
        }
        CreateConfigurationRequest other = (CreateConfigurationRequest)((Object)obj);
        return Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"CreateConfigurationRequest").add("EngineType", (Object)this.engineTypeAsString()).add("EngineVersion", (Object)this.engineVersion()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MqRequest.BuilderImpl
    implements Builder {
        private String engineType;
        private String engineVersion;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationRequest model) {
            super(model);
            this.engineType(model.engineType);
            this.engineVersion(model.engineVersion);
            this.name(model.name);
        }

        public final String getEngineType() {
            return this.engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType.toString());
            return this;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationRequest build() {
            return new CreateConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends MqRequest.Builder,
    CopyableBuilder<Builder, CreateConfigurationRequest> {
        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder engineVersion(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

