/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.User;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserMarshaller {
    private static final MarshallingInfo<Boolean> CONSOLEACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("consoleAccess").isBinary(false).build();
    private static final MarshallingInfo<List> GROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groups").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("password").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").isBinary(false).build();
    private static final UserMarshaller INSTANCE = new UserMarshaller();

    private UserMarshaller() {
    }

    public static UserMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(User user, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)user, (String)"user");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)user.consoleAccess(), CONSOLEACCESS_BINDING);
            protocolMarshaller.marshall(user.groups(), GROUPS_BINDING);
            protocolMarshaller.marshall((Object)user.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)user.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

