/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationIdMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<Integer> REVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").isBinary(false).build();
    private static final ConfigurationIdMarshaller INSTANCE = new ConfigurationIdMarshaller();

    private ConfigurationIdMarshaller() {
    }

    public static ConfigurationIdMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigurationId configurationId, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configurationId, (String)"configurationId");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configurationId.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)configurationId.revision(), REVISION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

