/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.services.mq.model.MQRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateBrokerRequest
extends MQRequest
implements ToCopyableBuilder<Builder, UpdateBrokerRequest> {
    private final String brokerId;
    private final ConfigurationId configuration;

    private UpdateBrokerRequest(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.configuration = builder.configuration;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public ConfigurationId configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerRequest)) {
            return false;
        }
        UpdateBrokerRequest other = (UpdateBrokerRequest)((Object)obj);
        return Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.configuration(), other.configuration());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBrokerRequest").add("BrokerId", (Object)this.brokerId()).add("Configuration", (Object)this.configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerId": {
                return Optional.of(clazz.cast(this.brokerId()));
            }
            case "Configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MQRequest.BuilderImpl
    implements Builder {
        private String brokerId;
        private ConfigurationId configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerRequest model) {
            super(model);
            this.brokerId(model.brokerId);
            this.configuration(model.configuration);
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final ConfigurationId.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ConfigurationId configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ConfigurationId.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrokerRequest build() {
            return new UpdateBrokerRequest(this);
        }
    }

    public static interface Builder
    extends MQRequest.Builder,
    CopyableBuilder<Builder, UpdateBrokerRequest> {
        public Builder brokerId(String var1);

        public Builder configuration(ConfigurationId var1);

        default public Builder configuration(Consumer<ConfigurationId.Builder> configuration) {
            return this.configuration((ConfigurationId)((ConfigurationId.Builder)ConfigurationId.builder().apply(configuration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

