/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.mq.model.BrokerSummary;
import software.amazon.awssdk.services.mq.model.ListOfBrokerSummaryCopier;
import software.amazon.awssdk.services.mq.model.MQResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBrokersResponse
extends MQResponse
implements ToCopyableBuilder<Builder, ListBrokersResponse> {
    private final List<BrokerSummary> brokerSummaries;
    private final String nextToken;

    private ListBrokersResponse(BuilderImpl builder) {
        super(builder);
        this.brokerSummaries = builder.brokerSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<BrokerSummary> brokerSummaries() {
        return this.brokerSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBrokersResponse)) {
            return false;
        }
        ListBrokersResponse other = (ListBrokersResponse)((Object)obj);
        return Objects.equals(this.brokerSummaries(), other.brokerSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListBrokersResponse").add("BrokerSummaries", this.brokerSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerSummaries": {
                return Optional.of(clazz.cast(this.brokerSummaries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MQResponse.BuilderImpl
    implements Builder {
        private List<BrokerSummary> brokerSummaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBrokersResponse model) {
            super(model);
            this.brokerSummaries(model.brokerSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<BrokerSummary.Builder> getBrokerSummaries() {
            return this.brokerSummaries != null ? (Collection)this.brokerSummaries.stream().map(BrokerSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder brokerSummaries(Collection<BrokerSummary> brokerSummaries) {
            this.brokerSummaries = ListOfBrokerSummaryCopier.copy(brokerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerSummaries(BrokerSummary ... brokerSummaries) {
            this.brokerSummaries(Arrays.asList(brokerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerSummaries(Consumer<BrokerSummary.Builder> ... brokerSummaries) {
            this.brokerSummaries(Stream.of(brokerSummaries).map(c -> (BrokerSummary)((BrokerSummary.Builder)BrokerSummary.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBrokerSummaries(Collection<BrokerSummary.BuilderImpl> brokerSummaries) {
            this.brokerSummaries = ListOfBrokerSummaryCopier.copyFromBuilder(brokerSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBrokersResponse build() {
            return new ListBrokersResponse(this);
        }
    }

    public static interface Builder
    extends MQResponse.Builder,
    CopyableBuilder<Builder, ListBrokersResponse> {
        public Builder brokerSummaries(Collection<BrokerSummary> var1);

        public Builder brokerSummaries(BrokerSummary ... var1);

        public Builder brokerSummaries(Consumer<BrokerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

