/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mpa.MpaClient;
import software.amazon.awssdk.services.mpa.internal.UserAgentUtils;
import software.amazon.awssdk.services.mpa.model.ListResourcePoliciesRequest;
import software.amazon.awssdk.services.mpa.model.ListResourcePoliciesResponse;
import software.amazon.awssdk.services.mpa.model.ListResourcePoliciesResponseResourcePolicy;

public class ListResourcePoliciesIterable
implements SdkIterable<ListResourcePoliciesResponse> {
    private final MpaClient client;
    private final ListResourcePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourcePoliciesIterable(MpaClient client, ListResourcePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourcePoliciesResponseFetcher();
    }

    public Iterator<ListResourcePoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListResourcePoliciesResponseResourcePolicy> resourcePolicies() {
        Function<ListResourcePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourcePolicies() != null) {
                return response.resourcePolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourcePoliciesResponseFetcher
    implements SyncPageFetcher<ListResourcePoliciesResponse> {
        private ListResourcePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourcePoliciesResponse nextPage(ListResourcePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListResourcePoliciesIterable.this.client.listResourcePolicies(ListResourcePoliciesIterable.this.firstRequest);
            }
            return ListResourcePoliciesIterable.this.client.listResourcePolicies((ListResourcePoliciesRequest)((Object)ListResourcePoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

