/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Strategy for how an approval team grants approval.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApprovalStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<ApprovalStrategy.Builder, ApprovalStrategy> {
    private static final SdkField<MofNApprovalStrategy> MOFN_FIELD = SdkField
            .<MofNApprovalStrategy> builder(MarshallingType.SDK_POJO).memberName("MofN").getter(getter(ApprovalStrategy::mofN))
            .setter(setter(Builder::mofN)).constructor(MofNApprovalStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MofN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOFN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MofNApprovalStrategy mofN;

    private final Type type;

    private ApprovalStrategy(BuilderImpl builder) {
        this.mofN = builder.mofN;
        this.type = builder.type;
    }

    /**
     * <p>
     * Minimum number of approvals (M) required for a total number of approvers (N).
     * </p>
     * 
     * @return Minimum number of approvals (M) required for a total number of approvers (N).
     */
    public final MofNApprovalStrategy mofN() {
        return mofN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mofN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalStrategy)) {
            return false;
        }
        ApprovalStrategy other = (ApprovalStrategy) obj;
        return Objects.equals(mofN(), other.mofN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApprovalStrategy").add("MofN", mofN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MofN":
            return Optional.ofNullable(clazz.cast(mofN()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #mofN()} initialized to the given value.
     *
     * <p>
     * Minimum number of approvals (M) required for a total number of approvers (N).
     * </p>
     * 
     * @param mofN
     *        Minimum number of approvals (M) required for a total number of approvers (N).
     */
    public static ApprovalStrategy fromMofN(MofNApprovalStrategy mofN) {
        return builder().mofN(mofN).build();
    }

    /**
     * Create an instance of this class with {@link #mofN()} initialized to the given value.
     *
     * <p>
     * Minimum number of approvals (M) required for a total number of approvers (N).
     * </p>
     * 
     * @param mofN
     *        Minimum number of approvals (M) required for a total number of approvers (N).
     */
    public static ApprovalStrategy fromMofN(Consumer<MofNApprovalStrategy.Builder> mofN) {
        MofNApprovalStrategy.Builder builder = MofNApprovalStrategy.builder();
        mofN.accept(builder);
        return fromMofN(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MofN", MOFN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApprovalStrategy, T> g) {
        return obj -> g.apply((ApprovalStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApprovalStrategy> {
        /**
         * <p>
         * Minimum number of approvals (M) required for a total number of approvers (N).
         * </p>
         * 
         * @param mofN
         *        Minimum number of approvals (M) required for a total number of approvers (N).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mofN(MofNApprovalStrategy mofN);

        /**
         * <p>
         * Minimum number of approvals (M) required for a total number of approvers (N).
         * </p>
         * This is a convenience method that creates an instance of the {@link MofNApprovalStrategy.Builder} avoiding
         * the need to create one manually via {@link MofNApprovalStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MofNApprovalStrategy.Builder#build()} is called immediately and
         * its result is passed to {@link #mofN(MofNApprovalStrategy)}.
         * 
         * @param mofN
         *        a consumer that will call methods on {@link MofNApprovalStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mofN(MofNApprovalStrategy)
         */
        default Builder mofN(Consumer<MofNApprovalStrategy.Builder> mofN) {
            return mofN(MofNApprovalStrategy.builder().applyMutation(mofN).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MofNApprovalStrategy mofN;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalStrategy model) {
            mofN(model.mofN);
        }

        public final MofNApprovalStrategy.Builder getMofN() {
            return mofN != null ? mofN.toBuilder() : null;
        }

        public final void setMofN(MofNApprovalStrategy.BuilderImpl mofN) {
            Object oldValue = this.mofN;
            this.mofN = mofN != null ? mofN.build() : null;
            handleUnionValueChange(Type.MOFN, oldValue, this.mofN);
        }

        @Override
        public final Builder mofN(MofNApprovalStrategy mofN) {
            Object oldValue = this.mofN;
            this.mofN = mofN;
            handleUnionValueChange(Type.MOFN, oldValue, this.mofN);
            return this;
        }

        @Override
        public ApprovalStrategy build() {
            return new ApprovalStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ApprovalStrategy#type()
     */
    public enum Type {
        MOFN,

        UNKNOWN_TO_SDK_VERSION
    }
}
