/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApprovalTeamRequest extends MpaRequest implements
        ToCopyableBuilder<UpdateApprovalTeamRequest.Builder, UpdateApprovalTeamRequest> {
    private static final SdkField<ApprovalStrategy> APPROVAL_STRATEGY_FIELD = SdkField
            .<ApprovalStrategy> builder(MarshallingType.SDK_POJO).memberName("ApprovalStrategy")
            .getter(getter(UpdateApprovalTeamRequest::approvalStrategy)).setter(setter(Builder::approvalStrategy))
            .constructor(ApprovalStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()).build();

    private static final SdkField<List<ApprovalTeamRequestApprover>> APPROVERS_FIELD = SdkField
            .<List<ApprovalTeamRequestApprover>> builder(MarshallingType.LIST)
            .memberName("Approvers")
            .getter(getter(UpdateApprovalTeamRequest::approvers))
            .setter(setter(Builder::approvers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Approvers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApprovalTeamRequestApprover> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApprovalTeamRequestApprover::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateApprovalTeamRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateApprovalTeamRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVAL_STRATEGY_FIELD,
            APPROVERS_FIELD, DESCRIPTION_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ApprovalStrategy approvalStrategy;

    private final List<ApprovalTeamRequestApprover> approvers;

    private final String description;

    private final String arn;

    private UpdateApprovalTeamRequest(BuilderImpl builder) {
        super(builder);
        this.approvalStrategy = builder.approvalStrategy;
        this.approvers = builder.approvers;
        this.description = builder.description;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
     * </p>
     * 
     * @return An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
     */
    public final ApprovalStrategy approvalStrategy() {
        return approvalStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Approvers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasApprovers() {
        return approvers != null && !(approvers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ApprovalTeamRequestApprover</code> objects. Contains details for the approvers in the team.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApprovers} method.
     * </p>
     * 
     * @return An array of <code>ApprovalTeamRequestApprover</code> objects. Contains details for the approvers in the
     *         team.
     */
    public final List<ApprovalTeamRequestApprover> approvers() {
        return approvers;
    }

    /**
     * <p>
     * Description for the team.
     * </p>
     * 
     * @return Description for the team.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the team.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the team.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovers() ? approvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApprovalTeamRequest)) {
            return false;
        }
        UpdateApprovalTeamRequest other = (UpdateApprovalTeamRequest) obj;
        return Objects.equals(approvalStrategy(), other.approvalStrategy()) && hasApprovers() == other.hasApprovers()
                && Objects.equals(approvers(), other.approvers()) && Objects.equals(description(), other.description())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApprovalTeamRequest").add("ApprovalStrategy", approvalStrategy())
                .add("Approvers", hasApprovers() ? approvers() : null)
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApprovalStrategy":
            return Optional.ofNullable(clazz.cast(approvalStrategy()));
        case "Approvers":
            return Optional.ofNullable(clazz.cast(approvers()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("Approvers", APPROVERS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApprovalTeamRequest, T> g) {
        return obj -> g.apply((UpdateApprovalTeamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApprovalTeamRequest> {
        /**
         * <p>
         * An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
         * </p>
         * 
         * @param approvalStrategy
         *        An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalStrategy(ApprovalStrategy approvalStrategy);

        /**
         * <p>
         * An <code>ApprovalStrategy</code> object. Contains details for how the team grants approval.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApprovalStrategy.Builder} avoiding the
         * need to create one manually via {@link ApprovalStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApprovalStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #approvalStrategy(ApprovalStrategy)}.
         * 
         * @param approvalStrategy
         *        a consumer that will call methods on {@link ApprovalStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalStrategy(ApprovalStrategy)
         */
        default Builder approvalStrategy(Consumer<ApprovalStrategy.Builder> approvalStrategy) {
            return approvalStrategy(ApprovalStrategy.builder().applyMutation(approvalStrategy).build());
        }

        /**
         * <p>
         * An array of <code>ApprovalTeamRequestApprover</code> objects. Contains details for the approvers in the team.
         * </p>
         * 
         * @param approvers
         *        An array of <code>ApprovalTeamRequestApprover</code> objects. Contains details for the approvers in
         *        the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvers(Collection<ApprovalTeamRequestApprover> approvers);

        /**
         * <p>
         * An array of <code>ApprovalTeamRequestApprover</code> objects. Contains details for the approvers in the team.
         * </p>
         * 
         * @param approvers
         *        An array of <code>ApprovalTeamRequestApprover</code> objects. Contains details for the approvers in
         *        the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvers(ApprovalTeamRequestApprover... approvers);

        /**
         * <p>
         * An array of <code>ApprovalTeamRequestApprover</code> objects. Contains details for the approvers in the team.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover.Builder#build()} is called
         * immediately and its result is passed to {@link #approvers(List<ApprovalTeamRequestApprover>)}.
         * 
         * @param approvers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mpa.model.ApprovalTeamRequestApprover.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvers(java.util.Collection<ApprovalTeamRequestApprover>)
         */
        Builder approvers(Consumer<ApprovalTeamRequestApprover.Builder>... approvers);

        /**
         * <p>
         * Description for the team.
         * </p>
         * 
         * @param description
         *        Description for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the team.
         * </p>
         * 
         * @param arn
         *        Amazon Resource Name (ARN) for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MpaRequest.BuilderImpl implements Builder {
        private ApprovalStrategy approvalStrategy;

        private List<ApprovalTeamRequestApprover> approvers = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApprovalTeamRequest model) {
            super(model);
            approvalStrategy(model.approvalStrategy);
            approvers(model.approvers);
            description(model.description);
            arn(model.arn);
        }

        public final ApprovalStrategy.Builder getApprovalStrategy() {
            return approvalStrategy != null ? approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategy.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategy approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final List<ApprovalTeamRequestApprover.Builder> getApprovers() {
            List<ApprovalTeamRequestApprover.Builder> result = ApprovalTeamRequestApproversCopier.copyToBuilder(this.approvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApprovers(Collection<ApprovalTeamRequestApprover.BuilderImpl> approvers) {
            this.approvers = ApprovalTeamRequestApproversCopier.copyFromBuilder(approvers);
        }

        @Override
        public final Builder approvers(Collection<ApprovalTeamRequestApprover> approvers) {
            this.approvers = ApprovalTeamRequestApproversCopier.copy(approvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(ApprovalTeamRequestApprover... approvers) {
            approvers(Arrays.asList(approvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(Consumer<ApprovalTeamRequestApprover.Builder>... approvers) {
            approvers(Stream.of(approvers).map(c -> ApprovalTeamRequestApprover.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApprovalTeamRequest build() {
            return new UpdateApprovalTeamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
