/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPoliciesResponse extends MpaResponse implements
        ToCopyableBuilder<ListPoliciesResponse.Builder, ListPoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Policy>> POLICIES_FIELD = SdkField
            .<List<Policy>> builder(MarshallingType.LIST)
            .memberName("Policies")
            .getter(getter(ListPoliciesResponse::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Policy> builder(MarshallingType.SDK_POJO)
                                            .constructor(Policy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Policy> policies;

    private ListPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.policies = builder.policies;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a next call to the operation to get more output. You can repeat
     * this until the <code>NextToken</code> response element returns <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a next call to the operation to get more output.
     *         You can repeat this until the <code>NextToken</code> response element returns <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Policy</code> objects. Contains a list of policies that define the permissions for team
     * resources.
     * </p>
     * <p>
     * The protected operation for a service integration might require specific permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
     * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return An array of <code>Policy</code> objects. Contains a list of policies that define the permissions for team
     *         resources.</p>
     *         <p>
     *         The protected operation for a service integration might require specific permissions. For more
     *         information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How
     *         other services work with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     */
    public final List<Policy> policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesResponse)) {
            return false;
        }
        ListPoliciesResponse other = (ListPoliciesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPolicies() == other.hasPolicies()
                && Objects.equals(policies(), other.policies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPoliciesResponse").add("NextToken", nextToken())
                .add("Policies", hasPolicies() ? policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Policies", POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesResponse, T> g) {
        return obj -> g.apply((ListPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPoliciesResponse> {
        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a next call to the operation to get more output. You can
         * repeat this until the <code>NextToken</code> response element returns <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a next call to the operation to get more
         *        output. You can repeat this until the <code>NextToken</code> response element returns
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of <code>Policy</code> objects. Contains a list of policies that define the permissions for team
         * resources.
         * </p>
         * <p>
         * The protected operation for a service integration might require specific permissions. For more information,
         * see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work
         * with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * </p>
         * 
         * @param policies
         *        An array of <code>Policy</code> objects. Contains a list of policies that define the permissions for
         *        team resources.</p>
         *        <p>
         *        The protected operation for a service integration might require specific permissions. For more
         *        information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How
         *        other services work with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<Policy> policies);

        /**
         * <p>
         * An array of <code>Policy</code> objects. Contains a list of policies that define the permissions for team
         * resources.
         * </p>
         * <p>
         * The protected operation for a service integration might require specific permissions. For more information,
         * see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work
         * with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * </p>
         * 
         * @param policies
         *        An array of <code>Policy</code> objects. Contains a list of policies that define the permissions for
         *        team resources.</p>
         *        <p>
         *        The protected operation for a service integration might require specific permissions. For more
         *        information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How
         *        other services work with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Policy... policies);

        /**
         * <p>
         * An array of <code>Policy</code> objects. Contains a list of policies that define the permissions for team
         * resources.
         * </p>
         * <p>
         * The protected operation for a service integration might require specific permissions. For more information,
         * see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work
         * with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mpa.model.Policy.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mpa.model.Policy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.mpa.model.Policy.Builder#build()}
         * is called immediately and its result is passed to {@link #policies(List<Policy>)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.mpa.model.Policy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(java.util.Collection<Policy>)
         */
        Builder policies(Consumer<Policy.Builder>... policies);
    }

    static final class BuilderImpl extends MpaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Policy> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesResponse model) {
            super(model);
            nextToken(model.nextToken);
            policies(model.policies);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Policy.Builder> getPolicies() {
            List<Policy.Builder> result = PoliciesCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<Policy.BuilderImpl> policies) {
            this.policies = PoliciesCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<Policy> policies) {
            this.policies = PoliciesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Policy... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<Policy.Builder>... policies) {
            policies(Stream.of(policies).map(c -> Policy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPoliciesResponse build() {
            return new ListPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
