/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for the resource that provides identities to the identity source. For example, an IAM Identity
 * Center instance. For more information, see <a
 * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity source</a> in the <i>Multi-party
 * approval User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentitySourceParametersForGet implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentitySourceParametersForGet.Builder, IdentitySourceParametersForGet> {
    private static final SdkField<IamIdentityCenterForGet> IAM_IDENTITY_CENTER_FIELD = SdkField
            .<IamIdentityCenterForGet> builder(MarshallingType.SDK_POJO).memberName("IamIdentityCenter")
            .getter(getter(IdentitySourceParametersForGet::iamIdentityCenter)).setter(setter(Builder::iamIdentityCenter))
            .constructor(IamIdentityCenterForGet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamIdentityCenter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_IDENTITY_CENTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IamIdentityCenterForGet iamIdentityCenter;

    private final Type type;

    private IdentitySourceParametersForGet(BuilderImpl builder) {
        this.iamIdentityCenter = builder.iamIdentityCenter;
        this.type = builder.type;
    }

    /**
     * <p>
     * IAM Identity Center credentials.
     * </p>
     * 
     * @return IAM Identity Center credentials.
     */
    public final IamIdentityCenterForGet iamIdentityCenter() {
        return iamIdentityCenter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityCenter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentitySourceParametersForGet)) {
            return false;
        }
        IdentitySourceParametersForGet other = (IdentitySourceParametersForGet) obj;
        return Objects.equals(iamIdentityCenter(), other.iamIdentityCenter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentitySourceParametersForGet").add("IamIdentityCenter", iamIdentityCenter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamIdentityCenter":
            return Optional.ofNullable(clazz.cast(iamIdentityCenter()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #iamIdentityCenter()} initialized to the given value.
     *
     * <p>
     * IAM Identity Center credentials.
     * </p>
     * 
     * @param iamIdentityCenter
     *        IAM Identity Center credentials.
     */
    public static IdentitySourceParametersForGet fromIamIdentityCenter(IamIdentityCenterForGet iamIdentityCenter) {
        return builder().iamIdentityCenter(iamIdentityCenter).build();
    }

    /**
     * Create an instance of this class with {@link #iamIdentityCenter()} initialized to the given value.
     *
     * <p>
     * IAM Identity Center credentials.
     * </p>
     * 
     * @param iamIdentityCenter
     *        IAM Identity Center credentials.
     */
    public static IdentitySourceParametersForGet fromIamIdentityCenter(Consumer<IamIdentityCenterForGet.Builder> iamIdentityCenter) {
        IamIdentityCenterForGet.Builder builder = IamIdentityCenterForGet.builder();
        iamIdentityCenter.accept(builder);
        return fromIamIdentityCenter(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IamIdentityCenter", IAM_IDENTITY_CENTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentitySourceParametersForGet, T> g) {
        return obj -> g.apply((IdentitySourceParametersForGet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentitySourceParametersForGet> {
        /**
         * <p>
         * IAM Identity Center credentials.
         * </p>
         * 
         * @param iamIdentityCenter
         *        IAM Identity Center credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityCenter(IamIdentityCenterForGet iamIdentityCenter);

        /**
         * <p>
         * IAM Identity Center credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamIdentityCenterForGet.Builder} avoiding
         * the need to create one manually via {@link IamIdentityCenterForGet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamIdentityCenterForGet.Builder#build()} is called immediately
         * and its result is passed to {@link #iamIdentityCenter(IamIdentityCenterForGet)}.
         * 
         * @param iamIdentityCenter
         *        a consumer that will call methods on {@link IamIdentityCenterForGet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamIdentityCenter(IamIdentityCenterForGet)
         */
        default Builder iamIdentityCenter(Consumer<IamIdentityCenterForGet.Builder> iamIdentityCenter) {
            return iamIdentityCenter(IamIdentityCenterForGet.builder().applyMutation(iamIdentityCenter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IamIdentityCenterForGet iamIdentityCenter;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IdentitySourceParametersForGet model) {
            iamIdentityCenter(model.iamIdentityCenter);
        }

        public final IamIdentityCenterForGet.Builder getIamIdentityCenter() {
            return iamIdentityCenter != null ? iamIdentityCenter.toBuilder() : null;
        }

        public final void setIamIdentityCenter(IamIdentityCenterForGet.BuilderImpl iamIdentityCenter) {
            Object oldValue = this.iamIdentityCenter;
            this.iamIdentityCenter = iamIdentityCenter != null ? iamIdentityCenter.build() : null;
            handleUnionValueChange(Type.IAM_IDENTITY_CENTER, oldValue, this.iamIdentityCenter);
        }

        @Override
        public final Builder iamIdentityCenter(IamIdentityCenterForGet iamIdentityCenter) {
            Object oldValue = this.iamIdentityCenter;
            this.iamIdentityCenter = iamIdentityCenter;
            handleUnionValueChange(Type.IAM_IDENTITY_CENTER, oldValue, this.iamIdentityCenter);
            return this;
        }

        @Override
        public IdentitySourceParametersForGet build() {
            return new IdentitySourceParametersForGet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IdentitySourceParametersForGet#type()
     */
    public enum Type {
        IAM_IDENTITY_CENTER,

        UNKNOWN_TO_SDK_VERSION
    }
}
