/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for an approver.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApprovalTeamRequestApprover implements SdkPojo, Serializable,
        ToCopyableBuilder<ApprovalTeamRequestApprover.Builder, ApprovalTeamRequestApprover> {
    private static final SdkField<String> PRIMARY_IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryIdentityId").getter(getter(ApprovalTeamRequestApprover::primaryIdentityId))
            .setter(setter(Builder::primaryIdentityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIdentityId").build()).build();

    private static final SdkField<String> PRIMARY_IDENTITY_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryIdentitySourceArn").getter(getter(ApprovalTeamRequestApprover::primaryIdentitySourceArn))
            .setter(setter(Builder::primaryIdentitySourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIdentitySourceArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_IDENTITY_ID_FIELD,
            PRIMARY_IDENTITY_SOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String primaryIdentityId;

    private final String primaryIdentitySourceArn;

    private ApprovalTeamRequestApprover(BuilderImpl builder) {
        this.primaryIdentityId = builder.primaryIdentityId;
        this.primaryIdentitySourceArn = builder.primaryIdentitySourceArn;
    }

    /**
     * <p>
     * ID for the user.
     * </p>
     * 
     * @return ID for the user.
     */
    public final String primaryIdentityId() {
        return primaryIdentityId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the identity source. The identity source manages the user authentication for
     * approvers.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the identity source. The identity source manages the user authentication
     *         for approvers.
     */
    public final String primaryIdentitySourceArn() {
        return primaryIdentitySourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryIdentityId());
        hashCode = 31 * hashCode + Objects.hashCode(primaryIdentitySourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalTeamRequestApprover)) {
            return false;
        }
        ApprovalTeamRequestApprover other = (ApprovalTeamRequestApprover) obj;
        return Objects.equals(primaryIdentityId(), other.primaryIdentityId())
                && Objects.equals(primaryIdentitySourceArn(), other.primaryIdentitySourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApprovalTeamRequestApprover").add("PrimaryIdentityId", primaryIdentityId())
                .add("PrimaryIdentitySourceArn", primaryIdentitySourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryIdentityId":
            return Optional.ofNullable(clazz.cast(primaryIdentityId()));
        case "PrimaryIdentitySourceArn":
            return Optional.ofNullable(clazz.cast(primaryIdentitySourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryIdentityId", PRIMARY_IDENTITY_ID_FIELD);
        map.put("PrimaryIdentitySourceArn", PRIMARY_IDENTITY_SOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApprovalTeamRequestApprover, T> g) {
        return obj -> g.apply((ApprovalTeamRequestApprover) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApprovalTeamRequestApprover> {
        /**
         * <p>
         * ID for the user.
         * </p>
         * 
         * @param primaryIdentityId
         *        ID for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryIdentityId(String primaryIdentityId);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the identity source. The identity source manages the user authentication for
         * approvers.
         * </p>
         * 
         * @param primaryIdentitySourceArn
         *        Amazon Resource Name (ARN) for the identity source. The identity source manages the user
         *        authentication for approvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryIdentitySourceArn(String primaryIdentitySourceArn);
    }

    static final class BuilderImpl implements Builder {
        private String primaryIdentityId;

        private String primaryIdentitySourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalTeamRequestApprover model) {
            primaryIdentityId(model.primaryIdentityId);
            primaryIdentitySourceArn(model.primaryIdentitySourceArn);
        }

        public final String getPrimaryIdentityId() {
            return primaryIdentityId;
        }

        public final void setPrimaryIdentityId(String primaryIdentityId) {
            this.primaryIdentityId = primaryIdentityId;
        }

        @Override
        public final Builder primaryIdentityId(String primaryIdentityId) {
            this.primaryIdentityId = primaryIdentityId;
            return this;
        }

        public final String getPrimaryIdentitySourceArn() {
            return primaryIdentitySourceArn;
        }

        public final void setPrimaryIdentitySourceArn(String primaryIdentitySourceArn) {
            this.primaryIdentitySourceArn = primaryIdentitySourceArn;
        }

        @Override
        public final Builder primaryIdentitySourceArn(String primaryIdentitySourceArn) {
            this.primaryIdentitySourceArn = primaryIdentitySourceArn;
            return this;
        }

        @Override
        public ApprovalTeamRequestApprover build() {
            return new ApprovalTeamRequestApprover(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
