/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mpa.model.ApprovalStrategyResponse;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamStatus;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApprovalTeamsResponseApprovalTeam
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListApprovalTeamsResponseApprovalTeam> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ListApprovalTeamsResponseApprovalTeam.getter(ListApprovalTeamsResponseApprovalTeam::creationTime)).setter(ListApprovalTeamsResponseApprovalTeam.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ApprovalStrategyResponse> APPROVAL_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApprovalStrategy").getter(ListApprovalTeamsResponseApprovalTeam.getter(ListApprovalTeamsResponseApprovalTeam::approvalStrategy)).setter(ListApprovalTeamsResponseApprovalTeam.setter(Builder::approvalStrategy)).constructor(ApprovalStrategyResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_APPROVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfApprovers").getter(ListApprovalTeamsResponseApprovalTeam.getter(ListApprovalTeamsResponseApprovalTeam::numberOfApprovers)).setter(ListApprovalTeamsResponseApprovalTeam.setter(Builder::numberOfApprovers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfApprovers").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListApprovalTeamsResponseApprovalTeam.getter(ListApprovalTeamsResponseApprovalTeam::arn)).setter(ListApprovalTeamsResponseApprovalTeam.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ListApprovalTeamsResponseApprovalTeam.getter(ListApprovalTeamsResponseApprovalTeam::name)).setter(ListApprovalTeamsResponseApprovalTeam.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ListApprovalTeamsResponseApprovalTeam.getter(ListApprovalTeamsResponseApprovalTeam::description)).setter(ListApprovalTeamsResponseApprovalTeam.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListApprovalTeamsResponseApprovalTeam.getter(ListApprovalTeamsResponseApprovalTeam::statusAsString)).setter(ListApprovalTeamsResponseApprovalTeam.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(ListApprovalTeamsResponseApprovalTeam.getter(ListApprovalTeamsResponseApprovalTeam::statusCodeAsString)).setter(ListApprovalTeamsResponseApprovalTeam.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ListApprovalTeamsResponseApprovalTeam.getter(ListApprovalTeamsResponseApprovalTeam::statusMessage)).setter(ListApprovalTeamsResponseApprovalTeam.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, APPROVAL_STRATEGY_FIELD, NUMBER_OF_APPROVERS_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListApprovalTeamsResponseApprovalTeam.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final ApprovalStrategyResponse approvalStrategy;
    private final Integer numberOfApprovers;
    private final String arn;
    private final String name;
    private final String description;
    private final String status;
    private final String statusCode;
    private final String statusMessage;

    private ListApprovalTeamsResponseApprovalTeam(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.approvalStrategy = builder.approvalStrategy;
        this.numberOfApprovers = builder.numberOfApprovers;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ApprovalStrategyResponse approvalStrategy() {
        return this.approvalStrategy;
    }

    public final Integer numberOfApprovers() {
        return this.numberOfApprovers;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ApprovalTeamStatus status() {
        return ApprovalTeamStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ApprovalTeamStatusCode statusCode() {
        return ApprovalTeamStatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfApprovers());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApprovalTeamsResponseApprovalTeam)) {
            return false;
        }
        ListApprovalTeamsResponseApprovalTeam other = (ListApprovalTeamsResponseApprovalTeam)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.approvalStrategy(), other.approvalStrategy()) && Objects.equals(this.numberOfApprovers(), other.numberOfApprovers()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ListApprovalTeamsResponseApprovalTeam").add("CreationTime", (Object)this.creationTime()).add("ApprovalStrategy", (Object)this.approvalStrategy()).add("NumberOfApprovers", (Object)this.numberOfApprovers()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ApprovalStrategy": {
                return Optional.ofNullable(clazz.cast(this.approvalStrategy()));
            }
            case "NumberOfApprovers": {
                return Optional.ofNullable(clazz.cast(this.numberOfApprovers()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("NumberOfApprovers", NUMBER_OF_APPROVERS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApprovalTeamsResponseApprovalTeam, T> g) {
        return obj -> g.apply((ListApprovalTeamsResponseApprovalTeam)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private ApprovalStrategyResponse approvalStrategy;
        private Integer numberOfApprovers;
        private String arn;
        private String name;
        private String description;
        private String status;
        private String statusCode;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApprovalTeamsResponseApprovalTeam model) {
            this.creationTime(model.creationTime);
            this.approvalStrategy(model.approvalStrategy);
            this.numberOfApprovers(model.numberOfApprovers);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ApprovalStrategyResponse.Builder getApprovalStrategy() {
            return this.approvalStrategy != null ? this.approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategyResponse.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final Integer getNumberOfApprovers() {
            return this.numberOfApprovers;
        }

        public final void setNumberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
        }

        @Override
        public final Builder numberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApprovalTeamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ApprovalTeamStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public ListApprovalTeamsResponseApprovalTeam build() {
            return new ListApprovalTeamsResponseApprovalTeam(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListApprovalTeamsResponseApprovalTeam> {
        public Builder creationTime(Instant var1);

        public Builder approvalStrategy(ApprovalStrategyResponse var1);

        default public Builder approvalStrategy(Consumer<ApprovalStrategyResponse.Builder> approvalStrategy) {
            return this.approvalStrategy((ApprovalStrategyResponse)((ApprovalStrategyResponse.Builder)ApprovalStrategyResponse.builder().applyMutation(approvalStrategy)).build());
        }

        public Builder numberOfApprovers(Integer var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ApprovalTeamStatus var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ApprovalTeamStatusCode var1);

        public Builder statusMessage(String var1);
    }
}

