/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the filter to apply to requests. You can specify up to 10 filters for a request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(Filter::fieldNameAsString)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(Filter::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Filter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            OPERATOR_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String operator;

    private final String value;

    private Filter(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * Name of the filter to use.
     * </p>
     * <note>
     * <p>
     * <b>Supported filters</b>
     * </p>
     * <p>
     * The supported filters for <a>ListSessions</a> are: <code>ActionName</code>, <code>SessionStatus</code>, and
     * <code>InitationTime</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link FilterField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldNameAsString}.
     * </p>
     * 
     * @return Name of the filter to use.</p> <note>
     *         <p>
     *         <b>Supported filters</b>
     *         </p>
     *         <p>
     *         The supported filters for <a>ListSessions</a> are: <code>ActionName</code>, <code>SessionStatus</code>,
     *         and <code>InitationTime</code>.
     *         </p>
     * @see FilterField
     */
    public final FilterField fieldName() {
        return FilterField.fromValue(fieldName);
    }

    /**
     * <p>
     * Name of the filter to use.
     * </p>
     * <note>
     * <p>
     * <b>Supported filters</b>
     * </p>
     * <p>
     * The supported filters for <a>ListSessions</a> are: <code>ActionName</code>, <code>SessionStatus</code>, and
     * <code>InitationTime</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldName} will
     * return {@link FilterField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldNameAsString}.
     * </p>
     * 
     * @return Name of the filter to use.</p> <note>
     *         <p>
     *         <b>Supported filters</b>
     *         </p>
     *         <p>
     *         The supported filters for <a>ListSessions</a> are: <code>ActionName</code>, <code>SessionStatus</code>,
     *         and <code>InitationTime</code>.
     *         </p>
     * @see FilterField
     */
    public final String fieldNameAsString() {
        return fieldName;
    }

    /**
     * <p>
     * Operator to use for filtering.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: Equal to the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NE</code>: Not equal to the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GT</code>: Greater than the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LT</code>: Less than the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GTE</code>: Greater than or equal to the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTE</code>: Less than or equal to the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONTAINS</code>: Contains the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CONTAINS</code>: Does not contain the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BETWEEN</code>: Between two values, inclusive of the specified values.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * <b>Supported operators for each filter</b>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ActionName</code>: <code>EQ</code> | <code>NE</code> | <code>CONTAINS</code> | <code>NOT_CONTAINS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SessionStatus</code>: <code>EQ</code> | <code>NE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InitiationTime</code>: <code>GT</code> | <code>LT</code> | <code>GTE</code> | <code>LTE</code> |
     * <code>BETWEEN</code>
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link Operator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return Operator to use for filtering.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: Equal to the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NE</code>: Not equal to the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GT</code>: Greater than the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LT</code>: Less than the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GTE</code>: Greater than or equal to the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTE</code>: Less than or equal to the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONTAINS</code>: Contains the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CONTAINS</code>: Does not contain the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BETWEEN</code>: Between two values, inclusive of the specified values.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         <b>Supported operators for each filter</b>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ActionName</code>: <code>EQ</code> | <code>NE</code> | <code>CONTAINS</code> |
     *         <code>NOT_CONTAINS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SessionStatus</code>: <code>EQ</code> | <code>NE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InitiationTime</code>: <code>GT</code> | <code>LT</code> | <code>GTE</code> | <code>LTE</code> |
     *         <code>BETWEEN</code>
     *         </p>
     *         </li>
     *         </ul>
     * @see Operator
     */
    public final Operator operator() {
        return Operator.fromValue(operator);
    }

    /**
     * <p>
     * Operator to use for filtering.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: Equal to the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NE</code>: Not equal to the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GT</code>: Greater than the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LT</code>: Less than the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GTE</code>: Greater than or equal to the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LTE</code>: Less than or equal to the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONTAINS</code>: Contains the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CONTAINS</code>: Does not contain the specified value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BETWEEN</code>: Between two values, inclusive of the specified values.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * <b>Supported operators for each filter</b>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ActionName</code>: <code>EQ</code> | <code>NE</code> | <code>CONTAINS</code> | <code>NOT_CONTAINS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SessionStatus</code>: <code>EQ</code> | <code>NE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InitiationTime</code>: <code>GT</code> | <code>LT</code> | <code>GTE</code> | <code>LTE</code> |
     * <code>BETWEEN</code>
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link Operator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return Operator to use for filtering.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: Equal to the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NE</code>: Not equal to the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GT</code>: Greater than the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LT</code>: Less than the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GTE</code>: Greater than or equal to the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LTE</code>: Less than or equal to the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONTAINS</code>: Contains the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CONTAINS</code>: Does not contain the specified value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BETWEEN</code>: Between two values, inclusive of the specified values.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         <b>Supported operators for each filter</b>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ActionName</code>: <code>EQ</code> | <code>NE</code> | <code>CONTAINS</code> |
     *         <code>NOT_CONTAINS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SessionStatus</code>: <code>EQ</code> | <code>NE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InitiationTime</code>: <code>GT</code> | <code>LT</code> | <code>GTE</code> | <code>LTE</code> |
     *         <code>BETWEEN</code>
     *         </p>
     *         </li>
     *         </ul>
     * @see Operator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * Value to use for filtering. For the <code>BETWEEN</code> operator, specify values in the format
     * <code>a AND b</code> (<code>AND</code> is case-insensitive).
     * </p>
     * 
     * @return Value to use for filtering. For the <code>BETWEEN</code> operator, specify values in the format
     *         <code>a AND b</code> (<code>AND</code> is case-insensitive).
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(fieldNameAsString(), other.fieldNameAsString())
                && Objects.equals(operatorAsString(), other.operatorAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("FieldName", fieldNameAsString()).add("Operator", operatorAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldNameAsString()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * Name of the filter to use.
         * </p>
         * <note>
         * <p>
         * <b>Supported filters</b>
         * </p>
         * <p>
         * The supported filters for <a>ListSessions</a> are: <code>ActionName</code>, <code>SessionStatus</code>, and
         * <code>InitationTime</code>.
         * </p>
         * </note>
         * 
         * @param fieldName
         *        Name of the filter to use.</p> <note>
         *        <p>
         *        <b>Supported filters</b>
         *        </p>
         *        <p>
         *        The supported filters for <a>ListSessions</a> are: <code>ActionName</code>, <code>SessionStatus</code>
         *        , and <code>InitationTime</code>.
         *        </p>
         * @see FilterField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterField
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * Name of the filter to use.
         * </p>
         * <note>
         * <p>
         * <b>Supported filters</b>
         * </p>
         * <p>
         * The supported filters for <a>ListSessions</a> are: <code>ActionName</code>, <code>SessionStatus</code>, and
         * <code>InitationTime</code>.
         * </p>
         * </note>
         * 
         * @param fieldName
         *        Name of the filter to use.</p> <note>
         *        <p>
         *        <b>Supported filters</b>
         *        </p>
         *        <p>
         *        The supported filters for <a>ListSessions</a> are: <code>ActionName</code>, <code>SessionStatus</code>
         *        , and <code>InitationTime</code>.
         *        </p>
         * @see FilterField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterField
         */
        Builder fieldName(FilterField fieldName);

        /**
         * <p>
         * Operator to use for filtering.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: Equal to the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NE</code>: Not equal to the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GT</code>: Greater than the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LT</code>: Less than the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GTE</code>: Greater than or equal to the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTE</code>: Less than or equal to the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONTAINS</code>: Contains the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CONTAINS</code>: Does not contain the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BETWEEN</code>: Between two values, inclusive of the specified values.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * <b>Supported operators for each filter</b>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ActionName</code>: <code>EQ</code> | <code>NE</code> | <code>CONTAINS</code> |
         * <code>NOT_CONTAINS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SessionStatus</code>: <code>EQ</code> | <code>NE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InitiationTime</code>: <code>GT</code> | <code>LT</code> | <code>GTE</code> | <code>LTE</code> |
         * <code>BETWEEN</code>
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param operator
         *        Operator to use for filtering.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: Equal to the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NE</code>: Not equal to the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GT</code>: Greater than the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LT</code>: Less than the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GTE</code>: Greater than or equal to the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTE</code>: Less than or equal to the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONTAINS</code>: Contains the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CONTAINS</code>: Does not contain the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BETWEEN</code>: Between two values, inclusive of the specified values.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        <b>Supported operators for each filter</b>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ActionName</code>: <code>EQ</code> | <code>NE</code> | <code>CONTAINS</code> |
         *        <code>NOT_CONTAINS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SessionStatus</code>: <code>EQ</code> | <code>NE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InitiationTime</code>: <code>GT</code> | <code>LT</code> | <code>GTE</code> | <code>LTE</code> |
         *        <code>BETWEEN</code>
         *        </p>
         *        </li>
         *        </ul>
         * @see Operator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operator
         */
        Builder operator(String operator);

        /**
         * <p>
         * Operator to use for filtering.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: Equal to the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NE</code>: Not equal to the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GT</code>: Greater than the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LT</code>: Less than the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GTE</code>: Greater than or equal to the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LTE</code>: Less than or equal to the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONTAINS</code>: Contains the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CONTAINS</code>: Does not contain the specified value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BETWEEN</code>: Between two values, inclusive of the specified values.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * <b>Supported operators for each filter</b>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ActionName</code>: <code>EQ</code> | <code>NE</code> | <code>CONTAINS</code> |
         * <code>NOT_CONTAINS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SessionStatus</code>: <code>EQ</code> | <code>NE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InitiationTime</code>: <code>GT</code> | <code>LT</code> | <code>GTE</code> | <code>LTE</code> |
         * <code>BETWEEN</code>
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param operator
         *        Operator to use for filtering.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: Equal to the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NE</code>: Not equal to the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GT</code>: Greater than the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LT</code>: Less than the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GTE</code>: Greater than or equal to the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LTE</code>: Less than or equal to the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONTAINS</code>: Contains the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CONTAINS</code>: Does not contain the specified value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BETWEEN</code>: Between two values, inclusive of the specified values.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        <b>Supported operators for each filter</b>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ActionName</code>: <code>EQ</code> | <code>NE</code> | <code>CONTAINS</code> |
         *        <code>NOT_CONTAINS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SessionStatus</code>: <code>EQ</code> | <code>NE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InitiationTime</code>: <code>GT</code> | <code>LT</code> | <code>GTE</code> | <code>LTE</code> |
         *        <code>BETWEEN</code>
         *        </p>
         *        </li>
         *        </ul>
         * @see Operator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operator
         */
        Builder operator(Operator operator);

        /**
         * <p>
         * Value to use for filtering. For the <code>BETWEEN</code> operator, specify values in the format
         * <code>a AND b</code> (<code>AND</code> is case-insensitive).
         * </p>
         * 
         * @param value
         *        Value to use for filtering. For the <code>BETWEEN</code> operator, specify values in the format
         *        <code>a AND b</code> (<code>AND</code> is case-insensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String operator;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            fieldName(model.fieldName);
            operator(model.operator);
            value(model.value);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public final Builder fieldName(FilterField fieldName) {
            this.fieldName(fieldName == null ? null : fieldName.toString());
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(Operator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
