/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mobile.MobileAsyncClient;
import software.amazon.awssdk.services.mobile.internal.UserAgentUtils;
import software.amazon.awssdk.services.mobile.model.ListBundlesRequest;
import software.amazon.awssdk.services.mobile.model.ListBundlesResponse;

public class ListBundlesPublisher
implements SdkPublisher<ListBundlesResponse> {
    private final MobileAsyncClient client;
    private final ListBundlesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBundlesPublisher(MobileAsyncClient client, ListBundlesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBundlesPublisher(MobileAsyncClient client, ListBundlesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBundlesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBundlesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBundlesResponseFetcher
    implements AsyncPageFetcher<ListBundlesResponse> {
        private ListBundlesResponseFetcher() {
        }

        public boolean hasNextPage(ListBundlesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBundlesResponse> nextPage(ListBundlesResponse previousPage) {
            if (previousPage == null) {
                return ListBundlesPublisher.this.client.listBundles(ListBundlesPublisher.this.firstRequest);
            }
            return ListBundlesPublisher.this.client.listBundles((ListBundlesRequest)((Object)ListBundlesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

