/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.mobile.DefaultMobileAsyncClientBuilder;
import software.amazon.awssdk.services.mobile.MobileAsyncClientBuilder;
import software.amazon.awssdk.services.mobile.MobileServiceClientConfiguration;
import software.amazon.awssdk.services.mobile.model.CreateProjectRequest;
import software.amazon.awssdk.services.mobile.model.CreateProjectResponse;
import software.amazon.awssdk.services.mobile.model.DeleteProjectRequest;
import software.amazon.awssdk.services.mobile.model.DeleteProjectResponse;
import software.amazon.awssdk.services.mobile.model.DescribeBundleRequest;
import software.amazon.awssdk.services.mobile.model.DescribeBundleResponse;
import software.amazon.awssdk.services.mobile.model.DescribeProjectRequest;
import software.amazon.awssdk.services.mobile.model.DescribeProjectResponse;
import software.amazon.awssdk.services.mobile.model.ExportBundleRequest;
import software.amazon.awssdk.services.mobile.model.ExportBundleResponse;
import software.amazon.awssdk.services.mobile.model.ExportProjectRequest;
import software.amazon.awssdk.services.mobile.model.ExportProjectResponse;
import software.amazon.awssdk.services.mobile.model.ListBundlesRequest;
import software.amazon.awssdk.services.mobile.model.ListBundlesResponse;
import software.amazon.awssdk.services.mobile.model.ListProjectsRequest;
import software.amazon.awssdk.services.mobile.model.ListProjectsResponse;
import software.amazon.awssdk.services.mobile.model.UpdateProjectRequest;
import software.amazon.awssdk.services.mobile.model.UpdateProjectResponse;
import software.amazon.awssdk.services.mobile.paginators.ListBundlesPublisher;
import software.amazon.awssdk.services.mobile.paginators.ListProjectsPublisher;

@SdkPublicApi
@ThreadSafe
public interface MobileAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "AWSMobileHubService";
    public static final String SERVICE_METADATA_ID = "mobile";

    default public CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateProjectResponse> createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) {
        return this.createProject((CreateProjectRequest)((Object)((CreateProjectRequest.Builder)CreateProjectRequest.builder().applyMutation(createProjectRequest)).build()));
    }

    default public CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteProjectResponse> deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) {
        return this.deleteProject((DeleteProjectRequest)((Object)((DeleteProjectRequest.Builder)DeleteProjectRequest.builder().applyMutation(deleteProjectRequest)).build()));
    }

    default public CompletableFuture<DescribeBundleResponse> describeBundle(DescribeBundleRequest describeBundleRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeBundleResponse> describeBundle(Consumer<DescribeBundleRequest.Builder> describeBundleRequest) {
        return this.describeBundle((DescribeBundleRequest)((Object)((DescribeBundleRequest.Builder)DescribeBundleRequest.builder().applyMutation(describeBundleRequest)).build()));
    }

    default public CompletableFuture<DescribeProjectResponse> describeProject(DescribeProjectRequest describeProjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeProjectResponse> describeProject(Consumer<DescribeProjectRequest.Builder> describeProjectRequest) {
        return this.describeProject((DescribeProjectRequest)((Object)((DescribeProjectRequest.Builder)DescribeProjectRequest.builder().applyMutation(describeProjectRequest)).build()));
    }

    default public CompletableFuture<ExportBundleResponse> exportBundle(ExportBundleRequest exportBundleRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ExportBundleResponse> exportBundle(Consumer<ExportBundleRequest.Builder> exportBundleRequest) {
        return this.exportBundle((ExportBundleRequest)((Object)((ExportBundleRequest.Builder)ExportBundleRequest.builder().applyMutation(exportBundleRequest)).build()));
    }

    default public CompletableFuture<ExportProjectResponse> exportProject(ExportProjectRequest exportProjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ExportProjectResponse> exportProject(Consumer<ExportProjectRequest.Builder> exportProjectRequest) {
        return this.exportProject((ExportProjectRequest)((Object)((ExportProjectRequest.Builder)ExportProjectRequest.builder().applyMutation(exportProjectRequest)).build()));
    }

    default public CompletableFuture<ListBundlesResponse> listBundles(ListBundlesRequest listBundlesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListBundlesResponse> listBundles(Consumer<ListBundlesRequest.Builder> listBundlesRequest) {
        return this.listBundles((ListBundlesRequest)((Object)((ListBundlesRequest.Builder)ListBundlesRequest.builder().applyMutation(listBundlesRequest)).build()));
    }

    default public CompletableFuture<ListBundlesResponse> listBundles() {
        return this.listBundles((ListBundlesRequest)((Object)ListBundlesRequest.builder().build()));
    }

    default public ListBundlesPublisher listBundlesPaginator() {
        return this.listBundlesPaginator((ListBundlesRequest)((Object)ListBundlesRequest.builder().build()));
    }

    default public ListBundlesPublisher listBundlesPaginator(ListBundlesRequest listBundlesRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListBundlesPublisher listBundlesPaginator(Consumer<ListBundlesRequest.Builder> listBundlesRequest) {
        return this.listBundlesPaginator((ListBundlesRequest)((Object)((ListBundlesRequest.Builder)ListBundlesRequest.builder().applyMutation(listBundlesRequest)).build()));
    }

    default public CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListProjectsResponse> listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return this.listProjects((ListProjectsRequest)((Object)((ListProjectsRequest.Builder)ListProjectsRequest.builder().applyMutation(listProjectsRequest)).build()));
    }

    default public CompletableFuture<ListProjectsResponse> listProjects() {
        return this.listProjects((ListProjectsRequest)((Object)ListProjectsRequest.builder().build()));
    }

    default public ListProjectsPublisher listProjectsPaginator() {
        return this.listProjectsPaginator((ListProjectsRequest)((Object)ListProjectsRequest.builder().build()));
    }

    default public ListProjectsPublisher listProjectsPaginator(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListProjectsPublisher listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return this.listProjectsPaginator((ListProjectsRequest)((Object)((ListProjectsRequest.Builder)ListProjectsRequest.builder().applyMutation(listProjectsRequest)).build()));
    }

    default public CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateProjectResponse> updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest) {
        return this.updateProject((UpdateProjectRequest)((Object)((UpdateProjectRequest.Builder)UpdateProjectRequest.builder().applyMutation(updateProjectRequest)).build()));
    }

    public MobileServiceClientConfiguration serviceClientConfiguration();

    public static MobileAsyncClient create() {
        return (MobileAsyncClient)MobileAsyncClient.builder().build();
    }

    public static MobileAsyncClientBuilder builder() {
        return new DefaultMobileAsyncClientBuilder();
    }
}

