/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure contains the details of the bundle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBundleResponse extends MobileResponse implements
        ToCopyableBuilder<DescribeBundleResponse.Builder, DescribeBundleResponse> {
    private static final SdkField<BundleDetails> DETAILS_FIELD = SdkField.<BundleDetails> builder(MarshallingType.SDK_POJO)
            .memberName("details").getter(getter(DescribeBundleResponse::details)).setter(setter(Builder::details))
            .constructor(BundleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD));

    private final BundleDetails details;

    private DescribeBundleResponse(BuilderImpl builder) {
        super(builder);
        this.details = builder.details;
    }

    /**
     * <p>
     * The details of the bundle.
     * </p>
     * 
     * @return The details of the bundle.
     */
    public final BundleDetails details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBundleResponse)) {
            return false;
        }
        DescribeBundleResponse other = (DescribeBundleResponse) obj;
        return Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBundleResponse").add("Details", details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBundleResponse, T> g) {
        return obj -> g.apply((DescribeBundleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MobileResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBundleResponse> {
        /**
         * <p>
         * The details of the bundle.
         * </p>
         * 
         * @param details
         *        The details of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(BundleDetails details);

        /**
         * <p>
         * The details of the bundle.
         * </p>
         * This is a convenience that creates an instance of the {@link BundleDetails.Builder} avoiding the need to
         * create one manually via {@link BundleDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link BundleDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(BundleDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link BundleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(BundleDetails)
         */
        default Builder details(Consumer<BundleDetails.Builder> details) {
            return details(BundleDetails.builder().applyMutation(details).build());
        }
    }

    static final class BuilderImpl extends MobileResponse.BuilderImpl implements Builder {
        private BundleDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBundleResponse model) {
            super(model);
            details(model.details);
        }

        public final BundleDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        @Override
        public final Builder details(BundleDetails details) {
            this.details = details;
            return this;
        }

        public final void setDetails(BundleDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public DescribeBundleResponse build() {
            return new DescribeBundleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
