/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request structure used to request details about a project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectRequest extends MobileRequest implements
        ToCopyableBuilder<DescribeProjectRequest.Builder, DescribeProjectRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProjectRequest::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectId").build()).build();

    private static final SdkField<Boolean> SYNC_FROM_RESOURCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeProjectRequest::syncFromResources)).setter(setter(Builder::syncFromResources))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("syncFromResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD,
            SYNC_FROM_RESOURCES_FIELD));

    private final String projectId;

    private final Boolean syncFromResources;

    private DescribeProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.syncFromResources = builder.syncFromResources;
    }

    /**
     * <p>
     * Unique project identifier.
     * </p>
     * 
     * @return Unique project identifier.
     */
    public String projectId() {
        return projectId;
    }

    /**
     * <p>
     * If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state of AWS
     * CloudFormation stacks in the AWS Mobile Hub project.
     * </p>
     * 
     * @return If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state
     *         of AWS CloudFormation stacks in the AWS Mobile Hub project.
     */
    public Boolean syncFromResources() {
        return syncFromResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(syncFromResources());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectRequest)) {
            return false;
        }
        DescribeProjectRequest other = (DescribeProjectRequest) obj;
        return Objects.equals(projectId(), other.projectId()) && Objects.equals(syncFromResources(), other.syncFromResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProjectRequest").add("ProjectId", projectId())
                .add("SyncFromResources", syncFromResources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "syncFromResources":
            return Optional.ofNullable(clazz.cast(syncFromResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectRequest, T> g) {
        return obj -> g.apply((DescribeProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MobileRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProjectRequest> {
        /**
         * <p>
         * Unique project identifier.
         * </p>
         * 
         * @param projectId
         *        Unique project identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update state of
         * AWS CloudFormation stacks in the AWS Mobile Hub project.
         * </p>
         * 
         * @param syncFromResources
         *        If set to true, causes AWS Mobile Hub to synchronize information from other services, e.g., update
         *        state of AWS CloudFormation stacks in the AWS Mobile Hub project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncFromResources(Boolean syncFromResources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MobileRequest.BuilderImpl implements Builder {
        private String projectId;

        private Boolean syncFromResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectRequest model) {
            super(model);
            projectId(model.projectId);
            syncFromResources(model.syncFromResources);
        }

        public final String getProjectId() {
            return projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public final Boolean getSyncFromResources() {
            return syncFromResources;
        }

        @Override
        public final Builder syncFromResources(Boolean syncFromResources) {
            this.syncFromResources = syncFromResources;
            return this;
        }

        public final void setSyncFromResources(Boolean syncFromResources) {
            this.syncFromResources = syncFromResources;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProjectRequest build() {
            return new DescribeProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
