/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzableServerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyzableServerSummary> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(AnalyzableServerSummary.getter(AnalyzableServerSummary::hostname)).setter(AnalyzableServerSummary.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddress").getter(AnalyzableServerSummary.getter(AnalyzableServerSummary::ipAddress)).setter(AnalyzableServerSummary.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(AnalyzableServerSummary.getter(AnalyzableServerSummary::source)).setter(AnalyzableServerSummary.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> VM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vmId").getter(AnalyzableServerSummary.getter(AnalyzableServerSummary::vmId)).setter(AnalyzableServerSummary.setter(Builder::vmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD, IP_ADDRESS_FIELD, SOURCE_FIELD, VM_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalyzableServerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostname;
    private final String ipAddress;
    private final String source;
    private final String vmId;

    private AnalyzableServerSummary(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.ipAddress = builder.ipAddress;
        this.source = builder.source;
        this.vmId = builder.vmId;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String source() {
        return this.source;
    }

    public final String vmId() {
        return this.vmId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzableServerSummary)) {
            return false;
        }
        AnalyzableServerSummary other = (AnalyzableServerSummary)obj;
        return Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.vmId(), other.vmId());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzableServerSummary").add("Hostname", (Object)this.hostname()).add("IpAddress", (Object)this.ipAddress()).add("Source", (Object)this.source()).add("VmId", (Object)this.vmId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "vmId": {
                return Optional.ofNullable(clazz.cast(this.vmId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("hostname", HOSTNAME_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("vmId", VM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyzableServerSummary, T> g) {
        return obj -> g.apply((AnalyzableServerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostname;
        private String ipAddress;
        private String source;
        private String vmId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzableServerSummary model) {
            this.hostname(model.hostname);
            this.ipAddress(model.ipAddress);
            this.source(model.source);
            this.vmId(model.vmId);
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getVmId() {
            return this.vmId;
        }

        public final void setVmId(String vmId) {
            this.vmId = vmId;
        }

        @Override
        public final Builder vmId(String vmId) {
            this.vmId = vmId;
            return this;
        }

        public AnalyzableServerSummary build() {
            return new AnalyzableServerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyzableServerSummary> {
        public Builder hostname(String var1);

        public Builder ipAddress(String var1);

        public Builder source(String var1);

        public Builder vmId(String var1);
    }
}

