/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.AwsManagedTargetDestination;
import software.amazon.awssdk.services.migrationhubstrategy.model.AwsManagedTargetDestinationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsManagedResources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsManagedResources> {
    private static final SdkField<List<String>> TARGET_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetDestination").getter(AwsManagedResources.getter(AwsManagedResources::targetDestinationAsStrings)).setter(AwsManagedResources.setter(Builder::targetDestinationWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDestination").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsManagedResources.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> targetDestination;

    private AwsManagedResources(BuilderImpl builder) {
        this.targetDestination = builder.targetDestination;
    }

    public final List<AwsManagedTargetDestination> targetDestination() {
        return AwsManagedTargetDestinationsCopier.copyStringToEnum(this.targetDestination);
    }

    public final boolean hasTargetDestination() {
        return this.targetDestination != null && !(this.targetDestination instanceof SdkAutoConstructList);
    }

    public final List<String> targetDestinationAsStrings() {
        return this.targetDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetDestination() ? this.targetDestinationAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsManagedResources)) {
            return false;
        }
        AwsManagedResources other = (AwsManagedResources)obj;
        return this.hasTargetDestination() == other.hasTargetDestination() && Objects.equals(this.targetDestinationAsStrings(), other.targetDestinationAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AwsManagedResources").add("TargetDestination", this.hasTargetDestination() ? this.targetDestinationAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetDestination": {
                return Optional.ofNullable(clazz.cast(this.targetDestinationAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("targetDestination", TARGET_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsManagedResources, T> g) {
        return obj -> g.apply((AwsManagedResources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> targetDestination = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsManagedResources model) {
            this.targetDestinationWithStrings(model.targetDestination);
        }

        public final Collection<String> getTargetDestination() {
            if (this.targetDestination instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetDestination;
        }

        public final void setTargetDestination(Collection<String> targetDestination) {
            this.targetDestination = AwsManagedTargetDestinationsCopier.copy(targetDestination);
        }

        @Override
        public final Builder targetDestinationWithStrings(Collection<String> targetDestination) {
            this.targetDestination = AwsManagedTargetDestinationsCopier.copy(targetDestination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDestinationWithStrings(String ... targetDestination) {
            this.targetDestinationWithStrings(Arrays.asList(targetDestination));
            return this;
        }

        @Override
        public final Builder targetDestination(Collection<AwsManagedTargetDestination> targetDestination) {
            this.targetDestination = AwsManagedTargetDestinationsCopier.copyEnumToString(targetDestination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDestination(AwsManagedTargetDestination ... targetDestination) {
            this.targetDestination(Arrays.asList(targetDestination));
            return this;
        }

        public AwsManagedResources build() {
            return new AwsManagedResources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsManagedResources> {
        public Builder targetDestinationWithStrings(Collection<String> var1);

        public Builder targetDestinationWithStrings(String ... var1);

        public Builder targetDestination(Collection<AwsManagedTargetDestination> var1);

        public Builder targetDestination(AwsManagedTargetDestination ... var1);
    }
}

