/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternReportStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary;
import software.amazon.awssdk.services.migrationhubstrategy.model.AppType;
import software.amazon.awssdk.services.migrationhubstrategy.model.AppUnitError;
import software.amazon.awssdk.services.migrationhubstrategy.model.DatabaseConfigDetail;
import software.amazon.awssdk.services.migrationhubstrategy.model.InclusionStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAntipatternSeveritySummaryCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.RecommendationSet;
import software.amazon.awssdk.services.migrationhubstrategy.model.ResourceSubType;
import software.amazon.awssdk.services.migrationhubstrategy.model.Result;
import software.amazon.awssdk.services.migrationhubstrategy.model.ResultListCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.RuntimeAnalysisStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.S3Object;
import software.amazon.awssdk.services.migrationhubstrategy.model.SourceCodeRepositoriesCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.SourceCodeRepository;
import software.amazon.awssdk.services.migrationhubstrategy.model.SrcCodeOrDbAnalysisStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationComponentDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationComponentDetail> {
    private static final SdkField<String> ANALYSIS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisStatus").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::analysisStatusAsString)).setter(ApplicationComponentDetail.setter(Builder::analysisStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisStatus").build()}).build();
    private static final SdkField<S3Object> ANTIPATTERN_REPORT_S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("antipatternReportS3Object").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::antipatternReportS3Object)).setter(ApplicationComponentDetail.setter(Builder::antipatternReportS3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportS3Object").build()}).build();
    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("antipatternReportStatus").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::antipatternReportStatusAsString)).setter(ApplicationComponentDetail.setter(Builder::antipatternReportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatus").build()}).build();
    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("antipatternReportStatusMessage").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::antipatternReportStatusMessage)).setter(ApplicationComponentDetail.setter(Builder::antipatternReportStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatusMessage").build()}).build();
    private static final SdkField<String> APP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appType").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::appTypeAsString)).setter(ApplicationComponentDetail.setter(Builder::appType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appType").build()}).build();
    private static final SdkField<AppUnitError> APP_UNIT_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("appUnitError").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::appUnitError)).setter(ApplicationComponentDetail.setter(Builder::appUnitError)).constructor(AppUnitError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appUnitError").build()}).build();
    private static final SdkField<String> ASSOCIATED_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedServerId").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::associatedServerId)).setter(ApplicationComponentDetail.setter(Builder::associatedServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedServerId").build()}).build();
    private static final SdkField<DatabaseConfigDetail> DATABASE_CONFIG_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("databaseConfigDetail").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::databaseConfigDetail)).setter(ApplicationComponentDetail.setter(Builder::databaseConfigDetail)).constructor(DatabaseConfigDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseConfigDetail").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::id)).setter(ApplicationComponentDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> INCLUSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inclusionStatus").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::inclusionStatusAsString)).setter(ApplicationComponentDetail.setter(Builder::inclusionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusionStatus").build()}).build();
    private static final SdkField<Instant> LAST_ANALYZED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastAnalyzedTimestamp").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::lastAnalyzedTimestamp)).setter(ApplicationComponentDetail.setter(Builder::lastAnalyzedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAnalyzedTimestamp").build()}).build();
    private static final SdkField<List<AntipatternSeveritySummary>> LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listAntipatternSeveritySummary").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::listAntipatternSeveritySummary)).setter(ApplicationComponentDetail.setter(Builder::listAntipatternSeveritySummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listAntipatternSeveritySummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AntipatternSeveritySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MORE_SERVER_ASSOCIATION_EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("moreServerAssociationExists").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::moreServerAssociationExists)).setter(ApplicationComponentDetail.setter(Builder::moreServerAssociationExists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moreServerAssociationExists").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::name)).setter(ApplicationComponentDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OS_DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osDriver").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::osDriver)).setter(ApplicationComponentDetail.setter(Builder::osDriver)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osDriver").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osVersion").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::osVersion)).setter(ApplicationComponentDetail.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()}).build();
    private static final SdkField<RecommendationSet> RECOMMENDATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommendationSet").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::recommendationSet)).setter(ApplicationComponentDetail.setter(Builder::recommendationSet)).constructor(RecommendationSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSet").build()}).build();
    private static final SdkField<String> RESOURCE_SUB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceSubType").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::resourceSubTypeAsString)).setter(ApplicationComponentDetail.setter(Builder::resourceSubType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSubType").build()}).build();
    private static final SdkField<List<Result>> RESULT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resultList").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::resultList)).setter(ApplicationComponentDetail.setter(Builder::resultList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Result::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RUNTIME_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeStatus").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::runtimeStatusAsString)).setter(ApplicationComponentDetail.setter(Builder::runtimeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeStatus").build()}).build();
    private static final SdkField<String> RUNTIME_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeStatusMessage").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::runtimeStatusMessage)).setter(ApplicationComponentDetail.setter(Builder::runtimeStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeStatusMessage").build()}).build();
    private static final SdkField<List<SourceCodeRepository>> SOURCE_CODE_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceCodeRepositories").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::sourceCodeRepositories)).setter(ApplicationComponentDetail.setter(Builder::sourceCodeRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceCodeRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ApplicationComponentDetail.getter(ApplicationComponentDetail::statusMessage)).setter(ApplicationComponentDetail.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_STATUS_FIELD, ANTIPATTERN_REPORT_S3_OBJECT_FIELD, ANTIPATTERN_REPORT_STATUS_FIELD, ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD, APP_TYPE_FIELD, APP_UNIT_ERROR_FIELD, ASSOCIATED_SERVER_ID_FIELD, DATABASE_CONFIG_DETAIL_FIELD, ID_FIELD, INCLUSION_STATUS_FIELD, LAST_ANALYZED_TIMESTAMP_FIELD, LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD, MORE_SERVER_ASSOCIATION_EXISTS_FIELD, NAME_FIELD, OS_DRIVER_FIELD, OS_VERSION_FIELD, RECOMMENDATION_SET_FIELD, RESOURCE_SUB_TYPE_FIELD, RESULT_LIST_FIELD, RUNTIME_STATUS_FIELD, RUNTIME_STATUS_MESSAGE_FIELD, SOURCE_CODE_REPOSITORIES_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String analysisStatus;
    private final S3Object antipatternReportS3Object;
    private final String antipatternReportStatus;
    private final String antipatternReportStatusMessage;
    private final String appType;
    private final AppUnitError appUnitError;
    private final String associatedServerId;
    private final DatabaseConfigDetail databaseConfigDetail;
    private final String id;
    private final String inclusionStatus;
    private final Instant lastAnalyzedTimestamp;
    private final List<AntipatternSeveritySummary> listAntipatternSeveritySummary;
    private final Boolean moreServerAssociationExists;
    private final String name;
    private final String osDriver;
    private final String osVersion;
    private final RecommendationSet recommendationSet;
    private final String resourceSubType;
    private final List<Result> resultList;
    private final String runtimeStatus;
    private final String runtimeStatusMessage;
    private final List<SourceCodeRepository> sourceCodeRepositories;
    private final String statusMessage;

    private ApplicationComponentDetail(BuilderImpl builder) {
        this.analysisStatus = builder.analysisStatus;
        this.antipatternReportS3Object = builder.antipatternReportS3Object;
        this.antipatternReportStatus = builder.antipatternReportStatus;
        this.antipatternReportStatusMessage = builder.antipatternReportStatusMessage;
        this.appType = builder.appType;
        this.appUnitError = builder.appUnitError;
        this.associatedServerId = builder.associatedServerId;
        this.databaseConfigDetail = builder.databaseConfigDetail;
        this.id = builder.id;
        this.inclusionStatus = builder.inclusionStatus;
        this.lastAnalyzedTimestamp = builder.lastAnalyzedTimestamp;
        this.listAntipatternSeveritySummary = builder.listAntipatternSeveritySummary;
        this.moreServerAssociationExists = builder.moreServerAssociationExists;
        this.name = builder.name;
        this.osDriver = builder.osDriver;
        this.osVersion = builder.osVersion;
        this.recommendationSet = builder.recommendationSet;
        this.resourceSubType = builder.resourceSubType;
        this.resultList = builder.resultList;
        this.runtimeStatus = builder.runtimeStatus;
        this.runtimeStatusMessage = builder.runtimeStatusMessage;
        this.sourceCodeRepositories = builder.sourceCodeRepositories;
        this.statusMessage = builder.statusMessage;
    }

    public final SrcCodeOrDbAnalysisStatus analysisStatus() {
        return SrcCodeOrDbAnalysisStatus.fromValue(this.analysisStatus);
    }

    public final String analysisStatusAsString() {
        return this.analysisStatus;
    }

    public final S3Object antipatternReportS3Object() {
        return this.antipatternReportS3Object;
    }

    public final AntipatternReportStatus antipatternReportStatus() {
        return AntipatternReportStatus.fromValue(this.antipatternReportStatus);
    }

    public final String antipatternReportStatusAsString() {
        return this.antipatternReportStatus;
    }

    public final String antipatternReportStatusMessage() {
        return this.antipatternReportStatusMessage;
    }

    public final AppType appType() {
        return AppType.fromValue(this.appType);
    }

    public final String appTypeAsString() {
        return this.appType;
    }

    public final AppUnitError appUnitError() {
        return this.appUnitError;
    }

    public final String associatedServerId() {
        return this.associatedServerId;
    }

    public final DatabaseConfigDetail databaseConfigDetail() {
        return this.databaseConfigDetail;
    }

    public final String id() {
        return this.id;
    }

    public final InclusionStatus inclusionStatus() {
        return InclusionStatus.fromValue(this.inclusionStatus);
    }

    public final String inclusionStatusAsString() {
        return this.inclusionStatus;
    }

    public final Instant lastAnalyzedTimestamp() {
        return this.lastAnalyzedTimestamp;
    }

    public final boolean hasListAntipatternSeveritySummary() {
        return this.listAntipatternSeveritySummary != null && !(this.listAntipatternSeveritySummary instanceof SdkAutoConstructList);
    }

    public final List<AntipatternSeveritySummary> listAntipatternSeveritySummary() {
        return this.listAntipatternSeveritySummary;
    }

    public final Boolean moreServerAssociationExists() {
        return this.moreServerAssociationExists;
    }

    public final String name() {
        return this.name;
    }

    public final String osDriver() {
        return this.osDriver;
    }

    public final String osVersion() {
        return this.osVersion;
    }

    public final RecommendationSet recommendationSet() {
        return this.recommendationSet;
    }

    public final ResourceSubType resourceSubType() {
        return ResourceSubType.fromValue(this.resourceSubType);
    }

    public final String resourceSubTypeAsString() {
        return this.resourceSubType;
    }

    public final boolean hasResultList() {
        return this.resultList != null && !(this.resultList instanceof SdkAutoConstructList);
    }

    public final List<Result> resultList() {
        return this.resultList;
    }

    public final RuntimeAnalysisStatus runtimeStatus() {
        return RuntimeAnalysisStatus.fromValue(this.runtimeStatus);
    }

    public final String runtimeStatusAsString() {
        return this.runtimeStatus;
    }

    public final String runtimeStatusMessage() {
        return this.runtimeStatusMessage;
    }

    public final boolean hasSourceCodeRepositories() {
        return this.sourceCodeRepositories != null && !(this.sourceCodeRepositories instanceof SdkAutoConstructList);
    }

    public final List<SourceCodeRepository> sourceCodeRepositories() {
        return this.sourceCodeRepositories;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.antipatternReportS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.antipatternReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.antipatternReportStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appUnitError());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseConfigDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAnalyzedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListAntipatternSeveritySummary() ? this.listAntipatternSeveritySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.moreServerAssociationExists());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.osDriver());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSubTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultList() ? this.resultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceCodeRepositories() ? this.sourceCodeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponentDetail)) {
            return false;
        }
        ApplicationComponentDetail other = (ApplicationComponentDetail)obj;
        return Objects.equals(this.analysisStatusAsString(), other.analysisStatusAsString()) && Objects.equals(this.antipatternReportS3Object(), other.antipatternReportS3Object()) && Objects.equals(this.antipatternReportStatusAsString(), other.antipatternReportStatusAsString()) && Objects.equals(this.antipatternReportStatusMessage(), other.antipatternReportStatusMessage()) && Objects.equals(this.appTypeAsString(), other.appTypeAsString()) && Objects.equals(this.appUnitError(), other.appUnitError()) && Objects.equals(this.associatedServerId(), other.associatedServerId()) && Objects.equals(this.databaseConfigDetail(), other.databaseConfigDetail()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.inclusionStatusAsString(), other.inclusionStatusAsString()) && Objects.equals(this.lastAnalyzedTimestamp(), other.lastAnalyzedTimestamp()) && this.hasListAntipatternSeveritySummary() == other.hasListAntipatternSeveritySummary() && Objects.equals(this.listAntipatternSeveritySummary(), other.listAntipatternSeveritySummary()) && Objects.equals(this.moreServerAssociationExists(), other.moreServerAssociationExists()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.osDriver(), other.osDriver()) && Objects.equals(this.osVersion(), other.osVersion()) && Objects.equals(this.recommendationSet(), other.recommendationSet()) && Objects.equals(this.resourceSubTypeAsString(), other.resourceSubTypeAsString()) && this.hasResultList() == other.hasResultList() && Objects.equals(this.resultList(), other.resultList()) && Objects.equals(this.runtimeStatusAsString(), other.runtimeStatusAsString()) && Objects.equals(this.runtimeStatusMessage(), other.runtimeStatusMessage()) && this.hasSourceCodeRepositories() == other.hasSourceCodeRepositories() && Objects.equals(this.sourceCodeRepositories(), other.sourceCodeRepositories()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationComponentDetail").add("AnalysisStatus", (Object)this.analysisStatusAsString()).add("AntipatternReportS3Object", (Object)this.antipatternReportS3Object()).add("AntipatternReportStatus", (Object)this.antipatternReportStatusAsString()).add("AntipatternReportStatusMessage", (Object)this.antipatternReportStatusMessage()).add("AppType", (Object)this.appTypeAsString()).add("AppUnitError", (Object)this.appUnitError()).add("AssociatedServerId", (Object)this.associatedServerId()).add("DatabaseConfigDetail", (Object)this.databaseConfigDetail()).add("Id", (Object)this.id()).add("InclusionStatus", (Object)this.inclusionStatusAsString()).add("LastAnalyzedTimestamp", (Object)this.lastAnalyzedTimestamp()).add("ListAntipatternSeveritySummary", this.hasListAntipatternSeveritySummary() ? this.listAntipatternSeveritySummary() : null).add("MoreServerAssociationExists", (Object)this.moreServerAssociationExists()).add("Name", (Object)this.name()).add("OsDriver", (Object)this.osDriver()).add("OsVersion", (Object)this.osVersion()).add("RecommendationSet", (Object)this.recommendationSet()).add("ResourceSubType", (Object)this.resourceSubTypeAsString()).add("ResultList", this.hasResultList() ? this.resultList() : null).add("RuntimeStatus", (Object)this.runtimeStatusAsString()).add("RuntimeStatusMessage", (Object)this.runtimeStatusMessage()).add("SourceCodeRepositories", this.hasSourceCodeRepositories() ? this.sourceCodeRepositories() : null).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analysisStatus": {
                return Optional.ofNullable(clazz.cast(this.analysisStatusAsString()));
            }
            case "antipatternReportS3Object": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportS3Object()));
            }
            case "antipatternReportStatus": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportStatusAsString()));
            }
            case "antipatternReportStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportStatusMessage()));
            }
            case "appType": {
                return Optional.ofNullable(clazz.cast(this.appTypeAsString()));
            }
            case "appUnitError": {
                return Optional.ofNullable(clazz.cast(this.appUnitError()));
            }
            case "associatedServerId": {
                return Optional.ofNullable(clazz.cast(this.associatedServerId()));
            }
            case "databaseConfigDetail": {
                return Optional.ofNullable(clazz.cast(this.databaseConfigDetail()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "inclusionStatus": {
                return Optional.ofNullable(clazz.cast(this.inclusionStatusAsString()));
            }
            case "lastAnalyzedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastAnalyzedTimestamp()));
            }
            case "listAntipatternSeveritySummary": {
                return Optional.ofNullable(clazz.cast(this.listAntipatternSeveritySummary()));
            }
            case "moreServerAssociationExists": {
                return Optional.ofNullable(clazz.cast(this.moreServerAssociationExists()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "osDriver": {
                return Optional.ofNullable(clazz.cast(this.osDriver()));
            }
            case "osVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersion()));
            }
            case "recommendationSet": {
                return Optional.ofNullable(clazz.cast(this.recommendationSet()));
            }
            case "resourceSubType": {
                return Optional.ofNullable(clazz.cast(this.resourceSubTypeAsString()));
            }
            case "resultList": {
                return Optional.ofNullable(clazz.cast(this.resultList()));
            }
            case "runtimeStatus": {
                return Optional.ofNullable(clazz.cast(this.runtimeStatusAsString()));
            }
            case "runtimeStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.runtimeStatusMessage()));
            }
            case "sourceCodeRepositories": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeRepositories()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationComponentDetail, T> g) {
        return obj -> g.apply((ApplicationComponentDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String analysisStatus;
        private S3Object antipatternReportS3Object;
        private String antipatternReportStatus;
        private String antipatternReportStatusMessage;
        private String appType;
        private AppUnitError appUnitError;
        private String associatedServerId;
        private DatabaseConfigDetail databaseConfigDetail;
        private String id;
        private String inclusionStatus;
        private Instant lastAnalyzedTimestamp;
        private List<AntipatternSeveritySummary> listAntipatternSeveritySummary = DefaultSdkAutoConstructList.getInstance();
        private Boolean moreServerAssociationExists;
        private String name;
        private String osDriver;
        private String osVersion;
        private RecommendationSet recommendationSet;
        private String resourceSubType;
        private List<Result> resultList = DefaultSdkAutoConstructList.getInstance();
        private String runtimeStatus;
        private String runtimeStatusMessage;
        private List<SourceCodeRepository> sourceCodeRepositories = DefaultSdkAutoConstructList.getInstance();
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationComponentDetail model) {
            this.analysisStatus(model.analysisStatus);
            this.antipatternReportS3Object(model.antipatternReportS3Object);
            this.antipatternReportStatus(model.antipatternReportStatus);
            this.antipatternReportStatusMessage(model.antipatternReportStatusMessage);
            this.appType(model.appType);
            this.appUnitError(model.appUnitError);
            this.associatedServerId(model.associatedServerId);
            this.databaseConfigDetail(model.databaseConfigDetail);
            this.id(model.id);
            this.inclusionStatus(model.inclusionStatus);
            this.lastAnalyzedTimestamp(model.lastAnalyzedTimestamp);
            this.listAntipatternSeveritySummary(model.listAntipatternSeveritySummary);
            this.moreServerAssociationExists(model.moreServerAssociationExists);
            this.name(model.name);
            this.osDriver(model.osDriver);
            this.osVersion(model.osVersion);
            this.recommendationSet(model.recommendationSet);
            this.resourceSubType(model.resourceSubType);
            this.resultList(model.resultList);
            this.runtimeStatus(model.runtimeStatus);
            this.runtimeStatusMessage(model.runtimeStatusMessage);
            this.sourceCodeRepositories(model.sourceCodeRepositories);
            this.statusMessage(model.statusMessage);
        }

        public final String getAnalysisStatus() {
            return this.analysisStatus;
        }

        public final void setAnalysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
        }

        @Override
        public final Builder analysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        @Override
        public final Builder analysisStatus(SrcCodeOrDbAnalysisStatus analysisStatus) {
            this.analysisStatus(analysisStatus == null ? null : analysisStatus.toString());
            return this;
        }

        public final S3Object.Builder getAntipatternReportS3Object() {
            return this.antipatternReportS3Object != null ? this.antipatternReportS3Object.toBuilder() : null;
        }

        public final void setAntipatternReportS3Object(S3Object.BuilderImpl antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object != null ? antipatternReportS3Object.build() : null;
        }

        @Override
        public final Builder antipatternReportS3Object(S3Object antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object;
            return this;
        }

        public final String getAntipatternReportStatus() {
            return this.antipatternReportStatus;
        }

        public final void setAntipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
        }

        @Override
        public final Builder antipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
            return this;
        }

        @Override
        public final Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus) {
            this.antipatternReportStatus(antipatternReportStatus == null ? null : antipatternReportStatus.toString());
            return this;
        }

        public final String getAntipatternReportStatusMessage() {
            return this.antipatternReportStatusMessage;
        }

        public final void setAntipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
        }

        @Override
        public final Builder antipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
            return this;
        }

        public final String getAppType() {
            return this.appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final AppUnitError.Builder getAppUnitError() {
            return this.appUnitError != null ? this.appUnitError.toBuilder() : null;
        }

        public final void setAppUnitError(AppUnitError.BuilderImpl appUnitError) {
            this.appUnitError = appUnitError != null ? appUnitError.build() : null;
        }

        @Override
        public final Builder appUnitError(AppUnitError appUnitError) {
            this.appUnitError = appUnitError;
            return this;
        }

        public final String getAssociatedServerId() {
            return this.associatedServerId;
        }

        public final void setAssociatedServerId(String associatedServerId) {
            this.associatedServerId = associatedServerId;
        }

        @Override
        public final Builder associatedServerId(String associatedServerId) {
            this.associatedServerId = associatedServerId;
            return this;
        }

        public final DatabaseConfigDetail.Builder getDatabaseConfigDetail() {
            return this.databaseConfigDetail != null ? this.databaseConfigDetail.toBuilder() : null;
        }

        public final void setDatabaseConfigDetail(DatabaseConfigDetail.BuilderImpl databaseConfigDetail) {
            this.databaseConfigDetail = databaseConfigDetail != null ? databaseConfigDetail.build() : null;
        }

        @Override
        public final Builder databaseConfigDetail(DatabaseConfigDetail databaseConfigDetail) {
            this.databaseConfigDetail = databaseConfigDetail;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInclusionStatus() {
            return this.inclusionStatus;
        }

        public final void setInclusionStatus(String inclusionStatus) {
            this.inclusionStatus = inclusionStatus;
        }

        @Override
        public final Builder inclusionStatus(String inclusionStatus) {
            this.inclusionStatus = inclusionStatus;
            return this;
        }

        @Override
        public final Builder inclusionStatus(InclusionStatus inclusionStatus) {
            this.inclusionStatus(inclusionStatus == null ? null : inclusionStatus.toString());
            return this;
        }

        public final Instant getLastAnalyzedTimestamp() {
            return this.lastAnalyzedTimestamp;
        }

        public final void setLastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
        }

        @Override
        public final Builder lastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
            return this;
        }

        public final List<AntipatternSeveritySummary.Builder> getListAntipatternSeveritySummary() {
            List<AntipatternSeveritySummary.Builder> result = ListAntipatternSeveritySummaryCopier.copyToBuilder(this.listAntipatternSeveritySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListAntipatternSeveritySummary(Collection<AntipatternSeveritySummary.BuilderImpl> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier.copyFromBuilder(listAntipatternSeveritySummary);
        }

        @Override
        public final Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier.copy(listAntipatternSeveritySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(AntipatternSeveritySummary ... listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary(Arrays.asList(listAntipatternSeveritySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(Consumer<AntipatternSeveritySummary.Builder> ... listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary(Stream.of(listAntipatternSeveritySummary).map(c -> (AntipatternSeveritySummary)((AntipatternSeveritySummary.Builder)AntipatternSeveritySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMoreServerAssociationExists() {
            return this.moreServerAssociationExists;
        }

        public final void setMoreServerAssociationExists(Boolean moreServerAssociationExists) {
            this.moreServerAssociationExists = moreServerAssociationExists;
        }

        @Override
        public final Builder moreServerAssociationExists(Boolean moreServerAssociationExists) {
            this.moreServerAssociationExists = moreServerAssociationExists;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOsDriver() {
            return this.osDriver;
        }

        public final void setOsDriver(String osDriver) {
            this.osDriver = osDriver;
        }

        @Override
        public final Builder osDriver(String osDriver) {
            this.osDriver = osDriver;
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final RecommendationSet.Builder getRecommendationSet() {
            return this.recommendationSet != null ? this.recommendationSet.toBuilder() : null;
        }

        public final void setRecommendationSet(RecommendationSet.BuilderImpl recommendationSet) {
            this.recommendationSet = recommendationSet != null ? recommendationSet.build() : null;
        }

        @Override
        public final Builder recommendationSet(RecommendationSet recommendationSet) {
            this.recommendationSet = recommendationSet;
            return this;
        }

        public final String getResourceSubType() {
            return this.resourceSubType;
        }

        public final void setResourceSubType(String resourceSubType) {
            this.resourceSubType = resourceSubType;
        }

        @Override
        public final Builder resourceSubType(String resourceSubType) {
            this.resourceSubType = resourceSubType;
            return this;
        }

        @Override
        public final Builder resourceSubType(ResourceSubType resourceSubType) {
            this.resourceSubType(resourceSubType == null ? null : resourceSubType.toString());
            return this;
        }

        public final List<Result.Builder> getResultList() {
            List<Result.Builder> result = ResultListCopier.copyToBuilder(this.resultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultList(Collection<Result.BuilderImpl> resultList) {
            this.resultList = ResultListCopier.copyFromBuilder(resultList);
        }

        @Override
        public final Builder resultList(Collection<Result> resultList) {
            this.resultList = ResultListCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(Result ... resultList) {
            this.resultList(Arrays.asList(resultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(Consumer<Result.Builder> ... resultList) {
            this.resultList(Stream.of(resultList).map(c -> (Result)((Result.Builder)Result.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRuntimeStatus() {
            return this.runtimeStatus;
        }

        public final void setRuntimeStatus(String runtimeStatus) {
            this.runtimeStatus = runtimeStatus;
        }

        @Override
        public final Builder runtimeStatus(String runtimeStatus) {
            this.runtimeStatus = runtimeStatus;
            return this;
        }

        @Override
        public final Builder runtimeStatus(RuntimeAnalysisStatus runtimeStatus) {
            this.runtimeStatus(runtimeStatus == null ? null : runtimeStatus.toString());
            return this;
        }

        public final String getRuntimeStatusMessage() {
            return this.runtimeStatusMessage;
        }

        public final void setRuntimeStatusMessage(String runtimeStatusMessage) {
            this.runtimeStatusMessage = runtimeStatusMessage;
        }

        @Override
        public final Builder runtimeStatusMessage(String runtimeStatusMessage) {
            this.runtimeStatusMessage = runtimeStatusMessage;
            return this;
        }

        public final List<SourceCodeRepository.Builder> getSourceCodeRepositories() {
            List<SourceCodeRepository.Builder> result = SourceCodeRepositoriesCopier.copyToBuilder(this.sourceCodeRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceCodeRepositories(Collection<SourceCodeRepository.BuilderImpl> sourceCodeRepositories) {
            this.sourceCodeRepositories = SourceCodeRepositoriesCopier.copyFromBuilder(sourceCodeRepositories);
        }

        @Override
        public final Builder sourceCodeRepositories(Collection<SourceCodeRepository> sourceCodeRepositories) {
            this.sourceCodeRepositories = SourceCodeRepositoriesCopier.copy(sourceCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCodeRepositories(SourceCodeRepository ... sourceCodeRepositories) {
            this.sourceCodeRepositories(Arrays.asList(sourceCodeRepositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCodeRepositories(Consumer<SourceCodeRepository.Builder> ... sourceCodeRepositories) {
            this.sourceCodeRepositories(Stream.of(sourceCodeRepositories).map(c -> (SourceCodeRepository)((SourceCodeRepository.Builder)SourceCodeRepository.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public ApplicationComponentDetail build() {
            return new ApplicationComponentDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationComponentDetail> {
        public Builder analysisStatus(String var1);

        public Builder analysisStatus(SrcCodeOrDbAnalysisStatus var1);

        public Builder antipatternReportS3Object(S3Object var1);

        default public Builder antipatternReportS3Object(Consumer<S3Object.Builder> antipatternReportS3Object) {
            return this.antipatternReportS3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(antipatternReportS3Object)).build());
        }

        public Builder antipatternReportStatus(String var1);

        public Builder antipatternReportStatus(AntipatternReportStatus var1);

        public Builder antipatternReportStatusMessage(String var1);

        public Builder appType(String var1);

        public Builder appType(AppType var1);

        public Builder appUnitError(AppUnitError var1);

        default public Builder appUnitError(Consumer<AppUnitError.Builder> appUnitError) {
            return this.appUnitError((AppUnitError)((AppUnitError.Builder)AppUnitError.builder().applyMutation(appUnitError)).build());
        }

        public Builder associatedServerId(String var1);

        public Builder databaseConfigDetail(DatabaseConfigDetail var1);

        default public Builder databaseConfigDetail(Consumer<DatabaseConfigDetail.Builder> databaseConfigDetail) {
            return this.databaseConfigDetail((DatabaseConfigDetail)((DatabaseConfigDetail.Builder)DatabaseConfigDetail.builder().applyMutation(databaseConfigDetail)).build());
        }

        public Builder id(String var1);

        public Builder inclusionStatus(String var1);

        public Builder inclusionStatus(InclusionStatus var1);

        public Builder lastAnalyzedTimestamp(Instant var1);

        public Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> var1);

        public Builder listAntipatternSeveritySummary(AntipatternSeveritySummary ... var1);

        public Builder listAntipatternSeveritySummary(Consumer<AntipatternSeveritySummary.Builder> ... var1);

        public Builder moreServerAssociationExists(Boolean var1);

        public Builder name(String var1);

        public Builder osDriver(String var1);

        public Builder osVersion(String var1);

        public Builder recommendationSet(RecommendationSet var1);

        default public Builder recommendationSet(Consumer<RecommendationSet.Builder> recommendationSet) {
            return this.recommendationSet((RecommendationSet)((RecommendationSet.Builder)RecommendationSet.builder().applyMutation(recommendationSet)).build());
        }

        public Builder resourceSubType(String var1);

        public Builder resourceSubType(ResourceSubType var1);

        public Builder resultList(Collection<Result> var1);

        public Builder resultList(Result ... var1);

        public Builder resultList(Consumer<Result.Builder> ... var1);

        public Builder runtimeStatus(String var1);

        public Builder runtimeStatus(RuntimeAnalysisStatus var1);

        public Builder runtimeStatusMessage(String var1);

        public Builder sourceCodeRepositories(Collection<SourceCodeRepository> var1);

        public Builder sourceCodeRepositories(SourceCodeRepository ... var1);

        public Builder sourceCodeRepositories(Consumer<SourceCodeRepository.Builder> ... var1);

        public Builder statusMessage(String var1);
    }
}

