/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppUnitErrorCategory {
    CREDENTIAL_ERROR("CREDENTIAL_ERROR"),
    CONNECTIVITY_ERROR("CONNECTIVITY_ERROR"),
    PERMISSION_ERROR("PERMISSION_ERROR"),
    UNSUPPORTED_ERROR("UNSUPPORTED_ERROR"),
    OTHER_ERROR("OTHER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppUnitErrorCategory> VALUE_MAP;
    private final String value;

    private AppUnitErrorCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppUnitErrorCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppUnitErrorCategory> knownValues() {
        EnumSet<AppUnitErrorCategory> knownValues = EnumSet.allOf(AppUnitErrorCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppUnitErrorCategory.class, AppUnitErrorCategory::toString);
    }
}

