/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.RecommendationReportStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.S3KeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationReportDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationReportDetails> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(RecommendationReportDetails.getter(RecommendationReportDetails::completionTime)).setter(RecommendationReportDetails.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Bucket").getter(RecommendationReportDetails.getter(RecommendationReportDetails::s3Bucket)).setter(RecommendationReportDetails.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<List<String>> S3_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("s3Keys").getter(RecommendationReportDetails.getter(RecommendationReportDetails::s3Keys)).setter(RecommendationReportDetails.setter(Builder::s3Keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(RecommendationReportDetails.getter(RecommendationReportDetails::startTime)).setter(RecommendationReportDetails.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RecommendationReportDetails.getter(RecommendationReportDetails::statusAsString)).setter(RecommendationReportDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(RecommendationReportDetails.getter(RecommendationReportDetails::statusMessage)).setter(RecommendationReportDetails.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD, S3_BUCKET_FIELD, S3_KEYS_FIELD, START_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant completionTime;
    private final String s3Bucket;
    private final List<String> s3Keys;
    private final Instant startTime;
    private final String status;
    private final String statusMessage;

    private RecommendationReportDetails(BuilderImpl builder) {
        this.completionTime = builder.completionTime;
        this.s3Bucket = builder.s3Bucket;
        this.s3Keys = builder.s3Keys;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final boolean hasS3Keys() {
        return this.s3Keys != null && !(this.s3Keys instanceof SdkAutoConstructList);
    }

    public final List<String> s3Keys() {
        return this.s3Keys;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final RecommendationReportStatus status() {
        return RecommendationReportStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Keys() ? this.s3Keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationReportDetails)) {
            return false;
        }
        RecommendationReportDetails other = (RecommendationReportDetails)obj;
        return Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && this.hasS3Keys() == other.hasS3Keys() && Objects.equals(this.s3Keys(), other.s3Keys()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationReportDetails").add("CompletionTime", (Object)this.completionTime()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Keys", this.hasS3Keys() ? this.s3Keys() : null).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "s3Keys": {
                return Optional.ofNullable(clazz.cast(this.s3Keys()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationReportDetails, T> g) {
        return obj -> g.apply((RecommendationReportDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant completionTime;
        private String s3Bucket;
        private List<String> s3Keys = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationReportDetails model) {
            this.completionTime(model.completionTime);
            this.s3Bucket(model.s3Bucket);
            this.s3Keys(model.s3Keys);
            this.startTime(model.startTime);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final Collection<String> getS3Keys() {
            if (this.s3Keys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.s3Keys;
        }

        public final void setS3Keys(Collection<String> s3Keys) {
            this.s3Keys = S3KeysCopier.copy(s3Keys);
        }

        @Override
        public final Builder s3Keys(Collection<String> s3Keys) {
            this.s3Keys = S3KeysCopier.copy(s3Keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Keys(String ... s3Keys) {
            this.s3Keys(Arrays.asList(s3Keys));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationReportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public RecommendationReportDetails build() {
            return new RecommendationReportDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationReportDetails> {
        public Builder completionTime(Instant var1);

        public Builder s3Bucket(String var1);

        public Builder s3Keys(Collection<String> var1);

        public Builder s3Keys(String ... var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(RecommendationReportStatus var1);

        public Builder statusMessage(String var1);
    }
}

