/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAssessmentRequest extends MigrationHubStrategyRequest implements
        ToCopyableBuilder<StartAssessmentRequest.Builder, StartAssessmentRequest> {
    private static final SdkField<List<AssessmentTarget>> ASSESSMENT_TARGETS_FIELD = SdkField
            .<List<AssessmentTarget>> builder(MarshallingType.LIST)
            .memberName("assessmentTargets")
            .getter(getter(StartAssessmentRequest::assessmentTargets))
            .setter(setter(Builder::assessmentTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> S3_BUCKET_FOR_ANALYSIS_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3bucketForAnalysisData").getter(getter(StartAssessmentRequest::s3bucketForAnalysisData))
            .setter(setter(Builder::s3bucketForAnalysisData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3bucketForAnalysisData").build())
            .build();

    private static final SdkField<String> S3_BUCKET_FOR_REPORT_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3bucketForReportData").getter(getter(StartAssessmentRequest::s3bucketForReportData))
            .setter(setter(Builder::s3bucketForReportData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3bucketForReportData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGETS_FIELD,
            S3_BUCKET_FOR_ANALYSIS_DATA_FIELD, S3_BUCKET_FOR_REPORT_DATA_FIELD));

    private final List<AssessmentTarget> assessmentTargets;

    private final String s3bucketForAnalysisData;

    private final String s3bucketForReportData;

    private StartAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTargets = builder.assessmentTargets;
        this.s3bucketForAnalysisData = builder.s3bucketForAnalysisData;
        this.s3bucketForReportData = builder.s3bucketForReportData;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssessmentTargets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssessmentTargets() {
        return assessmentTargets != null && !(assessmentTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of criteria for assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentTargets} method.
     * </p>
     * 
     * @return List of criteria for assessment.
     */
    public final List<AssessmentTarget> assessmentTargets() {
        return assessmentTargets;
    }

    /**
     * <p>
     * The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @return The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin
     *         with <code>migrationhub-strategy-</code>.
     */
    public final String s3bucketForAnalysisData() {
        return s3bucketForAnalysisData;
    }

    /**
     * <p>
     * The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @return The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     *         <code>migrationhub-strategy-</code>.
     */
    public final String s3bucketForReportData() {
        return s3bucketForReportData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentTargets() ? assessmentTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3bucketForAnalysisData());
        hashCode = 31 * hashCode + Objects.hashCode(s3bucketForReportData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssessmentRequest)) {
            return false;
        }
        StartAssessmentRequest other = (StartAssessmentRequest) obj;
        return hasAssessmentTargets() == other.hasAssessmentTargets()
                && Objects.equals(assessmentTargets(), other.assessmentTargets())
                && Objects.equals(s3bucketForAnalysisData(), other.s3bucketForAnalysisData())
                && Objects.equals(s3bucketForReportData(), other.s3bucketForReportData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAssessmentRequest")
                .add("AssessmentTargets", hasAssessmentTargets() ? assessmentTargets() : null)
                .add("S3bucketForAnalysisData", s3bucketForAnalysisData()).add("S3bucketForReportData", s3bucketForReportData())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTargets":
            return Optional.ofNullable(clazz.cast(assessmentTargets()));
        case "s3bucketForAnalysisData":
            return Optional.ofNullable(clazz.cast(s3bucketForAnalysisData()));
        case "s3bucketForReportData":
            return Optional.ofNullable(clazz.cast(s3bucketForReportData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssessmentRequest, T> g) {
        return obj -> g.apply((StartAssessmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAssessmentRequest> {
        /**
         * <p>
         * List of criteria for assessment.
         * </p>
         * 
         * @param assessmentTargets
         *        List of criteria for assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargets(Collection<AssessmentTarget> assessmentTargets);

        /**
         * <p>
         * List of criteria for assessment.
         * </p>
         * 
         * @param assessmentTargets
         *        List of criteria for assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargets(AssessmentTarget... assessmentTargets);

        /**
         * <p>
         * List of criteria for assessment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTarget.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentTargets(List<AssessmentTarget>)}.
         * 
         * @param assessmentTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentTargets(java.util.Collection<AssessmentTarget>)
         */
        Builder assessmentTargets(Consumer<AssessmentTarget.Builder>... assessmentTargets);

        /**
         * <p>
         * The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
         * <code>migrationhub-strategy-</code>.
         * </p>
         * 
         * @param s3bucketForAnalysisData
         *        The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin
         *        with <code>migrationhub-strategy-</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3bucketForAnalysisData(String s3bucketForAnalysisData);

        /**
         * <p>
         * The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
         * <code>migrationhub-strategy-</code>.
         * </p>
         * 
         * @param s3bucketForReportData
         *        The S3 bucket where all the reports generated by the service are stored. The bucket name must begin
         *        with <code>migrationhub-strategy-</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3bucketForReportData(String s3bucketForReportData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubStrategyRequest.BuilderImpl implements Builder {
        private List<AssessmentTarget> assessmentTargets = DefaultSdkAutoConstructList.getInstance();

        private String s3bucketForAnalysisData;

        private String s3bucketForReportData;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssessmentRequest model) {
            super(model);
            assessmentTargets(model.assessmentTargets);
            s3bucketForAnalysisData(model.s3bucketForAnalysisData);
            s3bucketForReportData(model.s3bucketForReportData);
        }

        public final List<AssessmentTarget.Builder> getAssessmentTargets() {
            List<AssessmentTarget.Builder> result = AssessmentTargetsCopier.copyToBuilder(this.assessmentTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentTargets(Collection<AssessmentTarget.BuilderImpl> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetsCopier.copyFromBuilder(assessmentTargets);
        }

        @Override
        public final Builder assessmentTargets(Collection<AssessmentTarget> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetsCopier.copy(assessmentTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(AssessmentTarget... assessmentTargets) {
            assessmentTargets(Arrays.asList(assessmentTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(Consumer<AssessmentTarget.Builder>... assessmentTargets) {
            assessmentTargets(Stream.of(assessmentTargets).map(c -> AssessmentTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getS3bucketForAnalysisData() {
            return s3bucketForAnalysisData;
        }

        public final void setS3bucketForAnalysisData(String s3bucketForAnalysisData) {
            this.s3bucketForAnalysisData = s3bucketForAnalysisData;
        }

        @Override
        public final Builder s3bucketForAnalysisData(String s3bucketForAnalysisData) {
            this.s3bucketForAnalysisData = s3bucketForAnalysisData;
            return this;
        }

        public final String getS3bucketForReportData() {
            return s3bucketForReportData;
        }

        public final void setS3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
        }

        @Override
        public final Builder s3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssessmentRequest build() {
            return new StartAssessmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
