/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.ImportFileTaskInformation;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskInformationCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImportFileTaskResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, ListImportFileTaskResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListImportFileTaskResponse.getter(ListImportFileTaskResponse::nextToken)).setter(ListImportFileTaskResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ImportFileTaskInformation>> TASK_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taskInfos").getter(ListImportFileTaskResponse.getter(ListImportFileTaskResponse::taskInfos)).setter(ListImportFileTaskResponse.setter(Builder::taskInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportFileTaskInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TASK_INFOS_FIELD));
    private final String nextToken;
    private final List<ImportFileTaskInformation> taskInfos;

    private ListImportFileTaskResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.taskInfos = builder.taskInfos;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTaskInfos() {
        return this.taskInfos != null && !(this.taskInfos instanceof SdkAutoConstructList);
    }

    public final List<ImportFileTaskInformation> taskInfos() {
        return this.taskInfos;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskInfos() ? this.taskInfos() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportFileTaskResponse)) {
            return false;
        }
        ListImportFileTaskResponse other = (ListImportFileTaskResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTaskInfos() == other.hasTaskInfos() && Objects.equals(this.taskInfos(), other.taskInfos());
    }

    public final String toString() {
        return ToString.builder((String)"ListImportFileTaskResponse").add("NextToken", (Object)this.nextToken()).add("TaskInfos", this.hasTaskInfos() ? this.taskInfos() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "taskInfos": {
                return Optional.ofNullable(clazz.cast(this.taskInfos()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImportFileTaskResponse, T> g) {
        return obj -> g.apply((ListImportFileTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ImportFileTaskInformation> taskInfos = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportFileTaskResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.taskInfos(model.taskInfos);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ImportFileTaskInformation.Builder> getTaskInfos() {
            List<ImportFileTaskInformation.Builder> result = ListImportFileTaskInformationCopier.copyToBuilder(this.taskInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskInfos(Collection<ImportFileTaskInformation.BuilderImpl> taskInfos) {
            this.taskInfos = ListImportFileTaskInformationCopier.copyFromBuilder(taskInfos);
        }

        @Override
        @Transient
        public final Builder taskInfos(Collection<ImportFileTaskInformation> taskInfos) {
            this.taskInfos = ListImportFileTaskInformationCopier.copy(taskInfos);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder taskInfos(ImportFileTaskInformation ... taskInfos) {
            this.taskInfos(Arrays.asList(taskInfos));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder taskInfos(Consumer<ImportFileTaskInformation.Builder> ... taskInfos) {
            this.taskInfos(Stream.of(taskInfos).map(c -> (ImportFileTaskInformation)((ImportFileTaskInformation.Builder)ImportFileTaskInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListImportFileTaskResponse build() {
            return new ListImportFileTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImportFileTaskResponse> {
        public Builder nextToken(String var1);

        public Builder taskInfos(Collection<ImportFileTaskInformation> var1);

        public Builder taskInfos(ImportFileTaskInformation ... var1);

        public Builder taskInfos(Consumer<ImportFileTaskInformation.Builder> ... var1);
    }
}

