/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the step in a migration workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowStepSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowStepSummary.Builder, WorkflowStepSummary> {
    private static final SdkField<String> STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stepId")
            .getter(getter(WorkflowStepSummary::stepId)).setter(setter(Builder::stepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(WorkflowStepSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STEP_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepActionType").getter(getter(WorkflowStepSummary::stepActionTypeAsString))
            .setter(setter(Builder::stepActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepActionType").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(WorkflowStepSummary::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("previous")
            .getter(getter(WorkflowStepSummary::previous))
            .setter(setter(Builder::previous))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NEXT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("next")
            .getter(getter(WorkflowStepSummary::next))
            .setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorkflowStepSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(WorkflowStepSummary::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Integer> NO_OF_SRV_COMPLETED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("noOfSrvCompleted").getter(getter(WorkflowStepSummary::noOfSrvCompleted))
            .setter(setter(Builder::noOfSrvCompleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noOfSrvCompleted").build()).build();

    private static final SdkField<Integer> NO_OF_SRV_FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("noOfSrvFailed").getter(getter(WorkflowStepSummary::noOfSrvFailed))
            .setter(setter(Builder::noOfSrvFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noOfSrvFailed").build()).build();

    private static final SdkField<Integer> TOTAL_NO_OF_SRV_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalNoOfSrv").getter(getter(WorkflowStepSummary::totalNoOfSrv)).setter(setter(Builder::totalNoOfSrv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalNoOfSrv").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(WorkflowStepSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SCRIPT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scriptLocation").getter(getter(WorkflowStepSummary::scriptLocation))
            .setter(setter(Builder::scriptLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_ID_FIELD, NAME_FIELD,
            STEP_ACTION_TYPE_FIELD, OWNER_FIELD, PREVIOUS_FIELD, NEXT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            NO_OF_SRV_COMPLETED_FIELD, NO_OF_SRV_FAILED_FIELD, TOTAL_NO_OF_SRV_FIELD, DESCRIPTION_FIELD, SCRIPT_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stepId;

    private final String name;

    private final String stepActionType;

    private final String owner;

    private final List<String> previous;

    private final List<String> next;

    private final String status;

    private final String statusMessage;

    private final Integer noOfSrvCompleted;

    private final Integer noOfSrvFailed;

    private final Integer totalNoOfSrv;

    private final String description;

    private final String scriptLocation;

    private WorkflowStepSummary(BuilderImpl builder) {
        this.stepId = builder.stepId;
        this.name = builder.name;
        this.stepActionType = builder.stepActionType;
        this.owner = builder.owner;
        this.previous = builder.previous;
        this.next = builder.next;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.noOfSrvCompleted = builder.noOfSrvCompleted;
        this.noOfSrvFailed = builder.noOfSrvFailed;
        this.totalNoOfSrv = builder.totalNoOfSrv;
        this.description = builder.description;
        this.scriptLocation = builder.scriptLocation;
    }

    /**
     * <p>
     * The ID of the step.
     * </p>
     * 
     * @return The ID of the step.
     */
    public final String stepId() {
        return stepId;
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * 
     * @return The name of the step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The action type of the step. You must run and update the status of a manual step for the workflow to continue
     * after the completion of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepActionType}
     * will return {@link StepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepActionTypeAsString}.
     * </p>
     * 
     * @return The action type of the step. You must run and update the status of a manual step for the workflow to
     *         continue after the completion of the step.
     * @see StepActionType
     */
    public final StepActionType stepActionType() {
        return StepActionType.fromValue(stepActionType);
    }

    /**
     * <p>
     * The action type of the step. You must run and update the status of a manual step for the workflow to continue
     * after the completion of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepActionType}
     * will return {@link StepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepActionTypeAsString}.
     * </p>
     * 
     * @return The action type of the step. You must run and update the status of a manual step for the workflow to
     *         continue after the completion of the step.
     * @see StepActionType
     */
    public final String stepActionTypeAsString() {
        return stepActionType;
    }

    /**
     * <p>
     * The owner of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The owner of the step.
     * @see Owner
     */
    public final Owner owner() {
        return Owner.fromValue(owner);
    }

    /**
     * <p>
     * The owner of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The owner of the step.
     * @see Owner
     */
    public final String ownerAsString() {
        return owner;
    }

    /**
     * For responses, this returns true if the service returned a value for the Previous property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrevious() {
        return previous != null && !(previous instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The previous step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrevious} method.
     * </p>
     * 
     * @return The previous step.
     */
    public final List<String> previous() {
        return previous;
    }

    /**
     * For responses, this returns true if the service returned a value for the Next property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNext() {
        return next != null && !(next instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The next step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNext} method.
     * </p>
     * 
     * @return The next step.
     */
    public final List<String> next() {
        return next;
    }

    /**
     * <p>
     * The status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step.
     * @see StepStatus
     */
    public final StepStatus status() {
        return StepStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step.
     * @see StepStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the migration workflow.
     * </p>
     * 
     * @return The status message of the migration workflow.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The number of servers that have been migrated.
     * </p>
     * 
     * @return The number of servers that have been migrated.
     */
    public final Integer noOfSrvCompleted() {
        return noOfSrvCompleted;
    }

    /**
     * <p>
     * The number of servers that have failed to migrate.
     * </p>
     * 
     * @return The number of servers that have failed to migrate.
     */
    public final Integer noOfSrvFailed() {
        return noOfSrvFailed;
    }

    /**
     * <p>
     * The total number of servers that have been migrated.
     * </p>
     * 
     * @return The total number of servers that have been migrated.
     */
    public final Integer totalNoOfSrv() {
        return totalNoOfSrv;
    }

    /**
     * <p>
     * The description of the step.
     * </p>
     * 
     * @return The description of the step.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The location of the script.
     * </p>
     * 
     * @return The location of the script.
     */
    public final String scriptLocation() {
        return scriptLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stepActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrevious() ? previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNext() ? next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(noOfSrvCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(noOfSrvFailed());
        hashCode = 31 * hashCode + Objects.hashCode(totalNoOfSrv());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(scriptLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepSummary)) {
            return false;
        }
        WorkflowStepSummary other = (WorkflowStepSummary) obj;
        return Objects.equals(stepId(), other.stepId()) && Objects.equals(name(), other.name())
                && Objects.equals(stepActionTypeAsString(), other.stepActionTypeAsString())
                && Objects.equals(ownerAsString(), other.ownerAsString()) && hasPrevious() == other.hasPrevious()
                && Objects.equals(previous(), other.previous()) && hasNext() == other.hasNext()
                && Objects.equals(next(), other.next()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(noOfSrvCompleted(), other.noOfSrvCompleted())
                && Objects.equals(noOfSrvFailed(), other.noOfSrvFailed()) && Objects.equals(totalNoOfSrv(), other.totalNoOfSrv())
                && Objects.equals(description(), other.description()) && Objects.equals(scriptLocation(), other.scriptLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowStepSummary").add("StepId", stepId()).add("Name", name())
                .add("StepActionType", stepActionTypeAsString()).add("Owner", ownerAsString())
                .add("Previous", hasPrevious() ? previous() : null).add("Next", hasNext() ? next() : null)
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("NoOfSrvCompleted", noOfSrvCompleted()).add("NoOfSrvFailed", noOfSrvFailed())
                .add("TotalNoOfSrv", totalNoOfSrv()).add("Description", description()).add("ScriptLocation", scriptLocation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepId":
            return Optional.ofNullable(clazz.cast(stepId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "stepActionType":
            return Optional.ofNullable(clazz.cast(stepActionTypeAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        case "previous":
            return Optional.ofNullable(clazz.cast(previous()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "noOfSrvCompleted":
            return Optional.ofNullable(clazz.cast(noOfSrvCompleted()));
        case "noOfSrvFailed":
            return Optional.ofNullable(clazz.cast(noOfSrvFailed()));
        case "totalNoOfSrv":
            return Optional.ofNullable(clazz.cast(totalNoOfSrv()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "scriptLocation":
            return Optional.ofNullable(clazz.cast(scriptLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepId", STEP_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("stepActionType", STEP_ACTION_TYPE_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("previous", PREVIOUS_FIELD);
        map.put("next", NEXT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("noOfSrvCompleted", NO_OF_SRV_COMPLETED_FIELD);
        map.put("noOfSrvFailed", NO_OF_SRV_FAILED_FIELD);
        map.put("totalNoOfSrv", TOTAL_NO_OF_SRV_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("scriptLocation", SCRIPT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepSummary, T> g) {
        return obj -> g.apply((WorkflowStepSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowStepSummary> {
        /**
         * <p>
         * The ID of the step.
         * </p>
         * 
         * @param stepId
         *        The ID of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepId(String stepId);

        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param name
         *        The name of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The action type of the step. You must run and update the status of a manual step for the workflow to continue
         * after the completion of the step.
         * </p>
         * 
         * @param stepActionType
         *        The action type of the step. You must run and update the status of a manual step for the workflow to
         *        continue after the completion of the step.
         * @see StepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepActionType
         */
        Builder stepActionType(String stepActionType);

        /**
         * <p>
         * The action type of the step. You must run and update the status of a manual step for the workflow to continue
         * after the completion of the step.
         * </p>
         * 
         * @param stepActionType
         *        The action type of the step. You must run and update the status of a manual step for the workflow to
         *        continue after the completion of the step.
         * @see StepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepActionType
         */
        Builder stepActionType(StepActionType stepActionType);

        /**
         * <p>
         * The owner of the step.
         * </p>
         * 
         * @param owner
         *        The owner of the step.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(String owner);

        /**
         * <p>
         * The owner of the step.
         * </p>
         * 
         * @param owner
         *        The owner of the step.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(Owner owner);

        /**
         * <p>
         * The previous step.
         * </p>
         * 
         * @param previous
         *        The previous step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(Collection<String> previous);

        /**
         * <p>
         * The previous step.
         * </p>
         * 
         * @param previous
         *        The previous step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(String... previous);

        /**
         * <p>
         * The next step.
         * </p>
         * 
         * @param next
         *        The next step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(Collection<String> next);

        /**
         * <p>
         * The next step.
         * </p>
         * 
         * @param next
         *        The next step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String... next);

        /**
         * <p>
         * The status of the step.
         * </p>
         * 
         * @param status
         *        The status of the step.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the step.
         * </p>
         * 
         * @param status
         *        The status of the step.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder status(StepStatus status);

        /**
         * <p>
         * The status message of the migration workflow.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The number of servers that have been migrated.
         * </p>
         * 
         * @param noOfSrvCompleted
         *        The number of servers that have been migrated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noOfSrvCompleted(Integer noOfSrvCompleted);

        /**
         * <p>
         * The number of servers that have failed to migrate.
         * </p>
         * 
         * @param noOfSrvFailed
         *        The number of servers that have failed to migrate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noOfSrvFailed(Integer noOfSrvFailed);

        /**
         * <p>
         * The total number of servers that have been migrated.
         * </p>
         * 
         * @param totalNoOfSrv
         *        The total number of servers that have been migrated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNoOfSrv(Integer totalNoOfSrv);

        /**
         * <p>
         * The description of the step.
         * </p>
         * 
         * @param description
         *        The description of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The location of the script.
         * </p>
         * 
         * @param scriptLocation
         *        The location of the script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptLocation(String scriptLocation);
    }

    static final class BuilderImpl implements Builder {
        private String stepId;

        private String name;

        private String stepActionType;

        private String owner;

        private List<String> previous = DefaultSdkAutoConstructList.getInstance();

        private List<String> next = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String statusMessage;

        private Integer noOfSrvCompleted;

        private Integer noOfSrvFailed;

        private Integer totalNoOfSrv;

        private String description;

        private String scriptLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepSummary model) {
            stepId(model.stepId);
            name(model.name);
            stepActionType(model.stepActionType);
            owner(model.owner);
            previous(model.previous);
            next(model.next);
            status(model.status);
            statusMessage(model.statusMessage);
            noOfSrvCompleted(model.noOfSrvCompleted);
            noOfSrvFailed(model.noOfSrvFailed);
            totalNoOfSrv(model.totalNoOfSrv);
            description(model.description);
            scriptLocation(model.scriptLocation);
        }

        public final String getStepId() {
            return stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStepActionType() {
            return stepActionType;
        }

        public final void setStepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
        }

        @Override
        public final Builder stepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
            return this;
        }

        @Override
        public final Builder stepActionType(StepActionType stepActionType) {
            this.stepActionType(stepActionType == null ? null : stepActionType.toString());
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final Collection<String> getPrevious() {
            if (previous instanceof SdkAutoConstructList) {
                return null;
            }
            return previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String... previous) {
            previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (next instanceof SdkAutoConstructList) {
                return null;
            }
            return next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String... next) {
            next(Arrays.asList(next));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Integer getNoOfSrvCompleted() {
            return noOfSrvCompleted;
        }

        public final void setNoOfSrvCompleted(Integer noOfSrvCompleted) {
            this.noOfSrvCompleted = noOfSrvCompleted;
        }

        @Override
        public final Builder noOfSrvCompleted(Integer noOfSrvCompleted) {
            this.noOfSrvCompleted = noOfSrvCompleted;
            return this;
        }

        public final Integer getNoOfSrvFailed() {
            return noOfSrvFailed;
        }

        public final void setNoOfSrvFailed(Integer noOfSrvFailed) {
            this.noOfSrvFailed = noOfSrvFailed;
        }

        @Override
        public final Builder noOfSrvFailed(Integer noOfSrvFailed) {
            this.noOfSrvFailed = noOfSrvFailed;
            return this;
        }

        public final Integer getTotalNoOfSrv() {
            return totalNoOfSrv;
        }

        public final void setTotalNoOfSrv(Integer totalNoOfSrv) {
            this.totalNoOfSrv = totalNoOfSrv;
        }

        @Override
        public final Builder totalNoOfSrv(Integer totalNoOfSrv) {
            this.totalNoOfSrv = totalNoOfSrv;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScriptLocation() {
            return scriptLocation;
        }

        public final void setScriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
        }

        @Override
        public final Builder scriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
            return this;
        }

        @Override
        public WorkflowStepSummary build() {
            return new WorkflowStepSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
