/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure to hold multiple values of an output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowStepOutputUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowStepOutputUnion.Builder, WorkflowStepOutputUnion> {
    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("integerValue").getter(getter(WorkflowStepOutputUnion::integerValue))
            .setter(setter(Builder::integerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(WorkflowStepOutputUnion::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<List<String>> LIST_OF_STRING_VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("listOfStringValue")
            .getter(getter(WorkflowStepOutputUnion::listOfStringValue))
            .setter(setter(Builder::listOfStringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listOfStringValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_VALUE_FIELD,
            STRING_VALUE_FIELD, LIST_OF_STRING_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer integerValue;

    private final String stringValue;

    private final List<String> listOfStringValue;

    private final Type type;

    private WorkflowStepOutputUnion(BuilderImpl builder) {
        this.integerValue = builder.integerValue;
        this.stringValue = builder.stringValue;
        this.listOfStringValue = builder.listOfStringValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * The integer value.
     * </p>
     * 
     * @return The integer value.
     */
    public final Integer integerValue() {
        return integerValue;
    }

    /**
     * <p>
     * The string value.
     * </p>
     * 
     * @return The string value.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListOfStringValue property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListOfStringValue() {
        return listOfStringValue != null && !(listOfStringValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of string value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListOfStringValue} method.
     * </p>
     * 
     * @return The list of string value.
     */
    public final List<String> listOfStringValue() {
        return listOfStringValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasListOfStringValue() ? listOfStringValue() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepOutputUnion)) {
            return false;
        }
        WorkflowStepOutputUnion other = (WorkflowStepOutputUnion) obj;
        return Objects.equals(integerValue(), other.integerValue()) && Objects.equals(stringValue(), other.stringValue())
                && hasListOfStringValue() == other.hasListOfStringValue()
                && Objects.equals(listOfStringValue(), other.listOfStringValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowStepOutputUnion").add("IntegerValue", integerValue()).add("StringValue", stringValue())
                .add("ListOfStringValue", hasListOfStringValue() ? listOfStringValue() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integerValue":
            return Optional.ofNullable(clazz.cast(integerValue()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "listOfStringValue":
            return Optional.ofNullable(clazz.cast(listOfStringValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #integerValue()} initialized to the given value.
     *
     * <p>
     * The integer value.
     * </p>
     * 
     * @param integerValue
     *        The integer value.
     */
    public static WorkflowStepOutputUnion fromIntegerValue(Integer integerValue) {
        return builder().integerValue(integerValue).build();
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * The string value.
     * </p>
     * 
     * @param stringValue
     *        The string value.
     */
    public static WorkflowStepOutputUnion fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #listOfStringValue()} initialized to the given value.
     *
     * <p>
     * The list of string value.
     * </p>
     * 
     * @param listOfStringValue
     *        The list of string value.
     */
    public static WorkflowStepOutputUnion fromListOfStringValue(List<String> listOfStringValue) {
        return builder().listOfStringValue(listOfStringValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("integerValue", INTEGER_VALUE_FIELD);
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("listOfStringValue", LIST_OF_STRING_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepOutputUnion, T> g) {
        return obj -> g.apply((WorkflowStepOutputUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowStepOutputUnion> {
        /**
         * <p>
         * The integer value.
         * </p>
         * 
         * @param integerValue
         *        The integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValue(Integer integerValue);

        /**
         * <p>
         * The string value.
         * </p>
         * 
         * @param stringValue
         *        The string value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * The list of string value.
         * </p>
         * 
         * @param listOfStringValue
         *        The list of string value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStringValue(Collection<String> listOfStringValue);

        /**
         * <p>
         * The list of string value.
         * </p>
         * 
         * @param listOfStringValue
         *        The list of string value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStringValue(String... listOfStringValue);
    }

    static final class BuilderImpl implements Builder {
        private Integer integerValue;

        private String stringValue;

        private List<String> listOfStringValue = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepOutputUnion model) {
            integerValue(model.integerValue);
            stringValue(model.stringValue);
            listOfStringValue(model.listOfStringValue);
        }

        public final Integer getIntegerValue() {
            return integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            Object oldValue = this.integerValue;
            this.integerValue = integerValue;
            handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            Object oldValue = this.integerValue;
            this.integerValue = integerValue;
            handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Collection<String> getListOfStringValue() {
            if (listOfStringValue instanceof SdkAutoConstructList) {
                return null;
            }
            return listOfStringValue;
        }

        public final void setListOfStringValue(Collection<String> listOfStringValue) {
            Object oldValue = this.listOfStringValue;
            this.listOfStringValue = MaxStringListCopier.copy(listOfStringValue);
            handleUnionValueChange(Type.LIST_OF_STRING_VALUE, oldValue, this.listOfStringValue);
        }

        @Override
        public final Builder listOfStringValue(Collection<String> listOfStringValue) {
            Object oldValue = this.listOfStringValue;
            this.listOfStringValue = MaxStringListCopier.copy(listOfStringValue);
            handleUnionValueChange(Type.LIST_OF_STRING_VALUE, oldValue, this.listOfStringValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfStringValue(String... listOfStringValue) {
            listOfStringValue(Arrays.asList(listOfStringValue));
            return this;
        }

        @Override
        public WorkflowStepOutputUnion build() {
            return new WorkflowStepOutputUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see WorkflowStepOutputUnion#type()
     */
    public enum Type {
        INTEGER_VALUE,

        STRING_VALUE,

        LIST_OF_STRING_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
