/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkflowRequest extends MigrationHubOrchestratorRequest implements
        ToCopyableBuilder<UpdateWorkflowRequest.Builder, UpdateWorkflowRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateWorkflowRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateWorkflowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateWorkflowRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, StepInput>> INPUT_PARAMETERS_FIELD = SdkField
            .<Map<String, StepInput>> builder(MarshallingType.MAP)
            .memberName("inputParameters")
            .getter(getter(UpdateWorkflowRequest::inputParameters))
            .setter(setter(Builder::inputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<StepInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> STEP_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stepTargets")
            .getter(getter(UpdateWorkflowRequest::stepTargets))
            .setter(setter(Builder::stepTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, INPUT_PARAMETERS_FIELD, STEP_TARGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String description;

    private final Map<String, StepInput> inputParameters;

    private final List<String> stepTargets;

    private UpdateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.inputParameters = builder.inputParameters;
        this.stepTargets = builder.stepTargets;
    }

    /**
     * <p>
     * The ID of the migration workflow.
     * </p>
     * 
     * @return The ID of the migration workflow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the migration workflow.
     * </p>
     * 
     * @return The name of the migration workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the migration workflow.
     * </p>
     * 
     * @return The description of the migration workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputParameters() {
        return inputParameters != null && !(inputParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The input parameters required to update a migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputParameters} method.
     * </p>
     * 
     * @return The input parameters required to update a migration workflow.
     */
    public final Map<String, StepInput> inputParameters() {
        return inputParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the StepTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStepTargets() {
        return stepTargets != null && !(stepTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The servers on which a step will be run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepTargets} method.
     * </p>
     * 
     * @return The servers on which a step will be run.
     */
    public final List<String> stepTargets() {
        return stepTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputParameters() ? inputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStepTargets() ? stepTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowRequest)) {
            return false;
        }
        UpdateWorkflowRequest other = (UpdateWorkflowRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasInputParameters() == other.hasInputParameters()
                && Objects.equals(inputParameters(), other.inputParameters()) && hasStepTargets() == other.hasStepTargets()
                && Objects.equals(stepTargets(), other.stepTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkflowRequest").add("Id", id()).add("Name", name()).add("Description", description())
                .add("InputParameters", inputParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StepTargets", hasStepTargets() ? stepTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inputParameters":
            return Optional.ofNullable(clazz.cast(inputParameters()));
        case "stepTargets":
            return Optional.ofNullable(clazz.cast(stepTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputParameters", INPUT_PARAMETERS_FIELD);
        map.put("stepTargets", STEP_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkflowRequest, T> g) {
        return obj -> g.apply((UpdateWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubOrchestratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateWorkflowRequest> {
        /**
         * <p>
         * The ID of the migration workflow.
         * </p>
         * 
         * @param id
         *        The ID of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the migration workflow.
         * </p>
         * 
         * @param name
         *        The name of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the migration workflow.
         * </p>
         * 
         * @param description
         *        The description of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The input parameters required to update a migration workflow.
         * </p>
         * 
         * @param inputParameters
         *        The input parameters required to update a migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParameters(Map<String, StepInput> inputParameters);

        /**
         * <p>
         * The servers on which a step will be run.
         * </p>
         * 
         * @param stepTargets
         *        The servers on which a step will be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTargets(Collection<String> stepTargets);

        /**
         * <p>
         * The servers on which a step will be run.
         * </p>
         * 
         * @param stepTargets
         *        The servers on which a step will be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTargets(String... stepTargets);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private Map<String, StepInput> inputParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<String> stepTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkflowRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            inputParameters(model.inputParameters);
            stepTargets(model.stepTargets);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, StepInput.Builder> getInputParameters() {
            Map<String, StepInput.Builder> result = StepInputParametersCopier.copyToBuilder(this.inputParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputParameters(Map<String, StepInput.BuilderImpl> inputParameters) {
            this.inputParameters = StepInputParametersCopier.copyFromBuilder(inputParameters);
        }

        @Override
        public final Builder inputParameters(Map<String, StepInput> inputParameters) {
            this.inputParameters = StepInputParametersCopier.copy(inputParameters);
            return this;
        }

        public final Collection<String> getStepTargets() {
            if (stepTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return stepTargets;
        }

        public final void setStepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
        }

        @Override
        public final Builder stepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepTargets(String... stepTargets) {
            stepTargets(Arrays.asList(stepTargets));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkflowRequest build() {
            return new UpdateWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
