/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateStepSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateStepSummary.Builder, TemplateStepSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(TemplateStepSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STEP_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepGroupId").getter(getter(TemplateStepSummary::stepGroupId)).setter(setter(Builder::stepGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepGroupId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(TemplateStepSummary::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TemplateStepSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STEP_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepActionType").getter(getter(TemplateStepSummary::stepActionTypeAsString))
            .setter(setter(Builder::stepActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepActionType").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(TemplateStepSummary::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(TemplateStepSummary::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("previous")
            .getter(getter(TemplateStepSummary::previous))
            .setter(setter(Builder::previous))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NEXT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("next")
            .getter(getter(TemplateStepSummary::next))
            .setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STEP_GROUP_ID_FIELD,
            TEMPLATE_ID_FIELD, NAME_FIELD, STEP_ACTION_TYPE_FIELD, TARGET_TYPE_FIELD, OWNER_FIELD, PREVIOUS_FIELD, NEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String stepGroupId;

    private final String templateId;

    private final String name;

    private final String stepActionType;

    private final String targetType;

    private final String owner;

    private final List<String> previous;

    private final List<String> next;

    private TemplateStepSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.stepGroupId = builder.stepGroupId;
        this.templateId = builder.templateId;
        this.name = builder.name;
        this.stepActionType = builder.stepActionType;
        this.targetType = builder.targetType;
        this.owner = builder.owner;
        this.previous = builder.previous;
        this.next = builder.next;
    }

    /**
     * <p>
     * The ID of the step.
     * </p>
     * 
     * @return The ID of the step.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the step group.
     * </p>
     * 
     * @return The ID of the step group.
     */
    public final String stepGroupId() {
        return stepGroupId;
    }

    /**
     * <p>
     * The ID of the template.
     * </p>
     * 
     * @return The ID of the template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * 
     * @return The name of the step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The action type of the step. You must run and update the status of a manual step for the workflow to continue
     * after the completion of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepActionType}
     * will return {@link StepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepActionTypeAsString}.
     * </p>
     * 
     * @return The action type of the step. You must run and update the status of a manual step for the workflow to
     *         continue after the completion of the step.
     * @see StepActionType
     */
    public final StepActionType stepActionType() {
        return StepActionType.fromValue(stepActionType);
    }

    /**
     * <p>
     * The action type of the step. You must run and update the status of a manual step for the workflow to continue
     * after the completion of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepActionType}
     * will return {@link StepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stepActionTypeAsString}.
     * </p>
     * 
     * @return The action type of the step. You must run and update the status of a manual step for the workflow to
     *         continue after the completion of the step.
     * @see StepActionType
     */
    public final String stepActionTypeAsString() {
        return stepActionType;
    }

    /**
     * <p>
     * The servers on which to run the script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The servers on which to run the script.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The servers on which to run the script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The servers on which to run the script.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The owner of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The owner of the step.
     * @see Owner
     */
    public final Owner owner() {
        return Owner.fromValue(owner);
    }

    /**
     * <p>
     * The owner of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The owner of the step.
     * @see Owner
     */
    public final String ownerAsString() {
        return owner;
    }

    /**
     * For responses, this returns true if the service returned a value for the Previous property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrevious() {
        return previous != null && !(previous instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The previous step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrevious} method.
     * </p>
     * 
     * @return The previous step.
     */
    public final List<String> previous() {
        return previous;
    }

    /**
     * For responses, this returns true if the service returned a value for the Next property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNext() {
        return next != null && !(next instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The next step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNext} method.
     * </p>
     * 
     * @return The next step.
     */
    public final List<String> next() {
        return next;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(stepGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stepActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrevious() ? previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNext() ? next() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateStepSummary)) {
            return false;
        }
        TemplateStepSummary other = (TemplateStepSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(stepGroupId(), other.stepGroupId())
                && Objects.equals(templateId(), other.templateId()) && Objects.equals(name(), other.name())
                && Objects.equals(stepActionTypeAsString(), other.stepActionTypeAsString())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(ownerAsString(), other.ownerAsString()) && hasPrevious() == other.hasPrevious()
                && Objects.equals(previous(), other.previous()) && hasNext() == other.hasNext()
                && Objects.equals(next(), other.next());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateStepSummary").add("Id", id()).add("StepGroupId", stepGroupId())
                .add("TemplateId", templateId()).add("Name", name()).add("StepActionType", stepActionTypeAsString())
                .add("TargetType", targetTypeAsString()).add("Owner", ownerAsString())
                .add("Previous", hasPrevious() ? previous() : null).add("Next", hasNext() ? next() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "stepGroupId":
            return Optional.ofNullable(clazz.cast(stepGroupId()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "stepActionType":
            return Optional.ofNullable(clazz.cast(stepActionTypeAsString()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        case "previous":
            return Optional.ofNullable(clazz.cast(previous()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("stepGroupId", STEP_GROUP_ID_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("stepActionType", STEP_ACTION_TYPE_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("previous", PREVIOUS_FIELD);
        map.put("next", NEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateStepSummary, T> g) {
        return obj -> g.apply((TemplateStepSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateStepSummary> {
        /**
         * <p>
         * The ID of the step.
         * </p>
         * 
         * @param id
         *        The ID of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the step group.
         * </p>
         * 
         * @param stepGroupId
         *        The ID of the step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepGroupId(String stepGroupId);

        /**
         * <p>
         * The ID of the template.
         * </p>
         * 
         * @param templateId
         *        The ID of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param name
         *        The name of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The action type of the step. You must run and update the status of a manual step for the workflow to continue
         * after the completion of the step.
         * </p>
         * 
         * @param stepActionType
         *        The action type of the step. You must run and update the status of a manual step for the workflow to
         *        continue after the completion of the step.
         * @see StepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepActionType
         */
        Builder stepActionType(String stepActionType);

        /**
         * <p>
         * The action type of the step. You must run and update the status of a manual step for the workflow to continue
         * after the completion of the step.
         * </p>
         * 
         * @param stepActionType
         *        The action type of the step. You must run and update the status of a manual step for the workflow to
         *        continue after the completion of the step.
         * @see StepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepActionType
         */
        Builder stepActionType(StepActionType stepActionType);

        /**
         * <p>
         * The servers on which to run the script.
         * </p>
         * 
         * @param targetType
         *        The servers on which to run the script.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The servers on which to run the script.
         * </p>
         * 
         * @param targetType
         *        The servers on which to run the script.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);

        /**
         * <p>
         * The owner of the step.
         * </p>
         * 
         * @param owner
         *        The owner of the step.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(String owner);

        /**
         * <p>
         * The owner of the step.
         * </p>
         * 
         * @param owner
         *        The owner of the step.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(Owner owner);

        /**
         * <p>
         * The previous step.
         * </p>
         * 
         * @param previous
         *        The previous step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(Collection<String> previous);

        /**
         * <p>
         * The previous step.
         * </p>
         * 
         * @param previous
         *        The previous step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(String... previous);

        /**
         * <p>
         * The next step.
         * </p>
         * 
         * @param next
         *        The next step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(Collection<String> next);

        /**
         * <p>
         * The next step.
         * </p>
         * 
         * @param next
         *        The next step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String... next);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String stepGroupId;

        private String templateId;

        private String name;

        private String stepActionType;

        private String targetType;

        private String owner;

        private List<String> previous = DefaultSdkAutoConstructList.getInstance();

        private List<String> next = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateStepSummary model) {
            id(model.id);
            stepGroupId(model.stepGroupId);
            templateId(model.templateId);
            name(model.name);
            stepActionType(model.stepActionType);
            targetType(model.targetType);
            owner(model.owner);
            previous(model.previous);
            next(model.next);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStepGroupId() {
            return stepGroupId;
        }

        public final void setStepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
        }

        @Override
        public final Builder stepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStepActionType() {
            return stepActionType;
        }

        public final void setStepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
        }

        @Override
        public final Builder stepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
            return this;
        }

        @Override
        public final Builder stepActionType(StepActionType stepActionType) {
            this.stepActionType(stepActionType == null ? null : stepActionType.toString());
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final Collection<String> getPrevious() {
            if (previous instanceof SdkAutoConstructList) {
                return null;
            }
            return previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String... previous) {
            previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (next instanceof SdkAutoConstructList) {
                return null;
            }
            return next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String... next) {
            next(Arrays.asList(next));
            return this;
        }

        @Override
        public TemplateStepSummary build() {
            return new TemplateStepSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
