/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopWorkflowResponse extends MigrationHubOrchestratorResponse implements
        ToCopyableBuilder<StopWorkflowResponse.Builder, StopWorkflowResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(StopWorkflowResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(StopWorkflowResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StopWorkflowResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(StopWorkflowResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Instant> LAST_STOP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStopTime").getter(getter(StopWorkflowResponse::lastStopTime)).setter(setter(Builder::lastStopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStopTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, LAST_STOP_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String status;

    private final String statusMessage;

    private final Instant lastStopTime;

    private StopWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.lastStopTime = builder.lastStopTime;
    }

    /**
     * <p>
     * The ID of the migration workflow.
     * </p>
     * 
     * @return The ID of the migration workflow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the migration workflow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the migration workflow.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the migration workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MigrationWorkflowStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the migration workflow.
     * @see MigrationWorkflowStatusEnum
     */
    public final MigrationWorkflowStatusEnum status() {
        return MigrationWorkflowStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * The status of the migration workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MigrationWorkflowStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the migration workflow.
     * @see MigrationWorkflowStatusEnum
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the migration workflow.
     * </p>
     * 
     * @return The status message of the migration workflow.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The time at which the migration workflow was stopped.
     * </p>
     * 
     * @return The time at which the migration workflow was stopped.
     */
    public final Instant lastStopTime() {
        return lastStopTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastStopTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopWorkflowResponse)) {
            return false;
        }
        StopWorkflowResponse other = (StopWorkflowResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(lastStopTime(), other.lastStopTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopWorkflowResponse").add("Id", id()).add("Arn", arn()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("LastStopTime", lastStopTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "lastStopTime":
            return Optional.ofNullable(clazz.cast(lastStopTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("lastStopTime", LAST_STOP_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopWorkflowResponse, T> g) {
        return obj -> g.apply((StopWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubOrchestratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopWorkflowResponse> {
        /**
         * <p>
         * The ID of the migration workflow.
         * </p>
         * 
         * @param id
         *        The ID of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the migration workflow.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the migration workflow.
         * </p>
         * 
         * @param status
         *        The status of the migration workflow.
         * @see MigrationWorkflowStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationWorkflowStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the migration workflow.
         * </p>
         * 
         * @param status
         *        The status of the migration workflow.
         * @see MigrationWorkflowStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationWorkflowStatusEnum
         */
        Builder status(MigrationWorkflowStatusEnum status);

        /**
         * <p>
         * The status message of the migration workflow.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The time at which the migration workflow was stopped.
         * </p>
         * 
         * @param lastStopTime
         *        The time at which the migration workflow was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStopTime(Instant lastStopTime);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private String statusMessage;

        private Instant lastStopTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StopWorkflowResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            status(model.status);
            statusMessage(model.statusMessage);
            lastStopTime(model.lastStopTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MigrationWorkflowStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getLastStopTime() {
            return lastStopTime;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        @Override
        public StopWorkflowResponse build() {
            return new StopWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
