/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the Migration Hub Orchestrator plugin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PluginSummary implements SdkPojo, Serializable, ToCopyableBuilder<PluginSummary.Builder, PluginSummary> {
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginId").getter(getter(PluginSummary::pluginId)).setter(setter(Builder::pluginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(PluginSummary::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(PluginSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddress").getter(getter(PluginSummary::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(PluginSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> REGISTERED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registeredTime").getter(getter(PluginSummary::registeredTime)).setter(setter(Builder::registeredTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLUGIN_ID_FIELD,
            HOSTNAME_FIELD, STATUS_FIELD, IP_ADDRESS_FIELD, VERSION_FIELD, REGISTERED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pluginId;

    private final String hostname;

    private final String status;

    private final String ipAddress;

    private final String version;

    private final String registeredTime;

    private PluginSummary(BuilderImpl builder) {
        this.pluginId = builder.pluginId;
        this.hostname = builder.hostname;
        this.status = builder.status;
        this.ipAddress = builder.ipAddress;
        this.version = builder.version;
        this.registeredTime = builder.registeredTime;
    }

    /**
     * <p>
     * The ID of the plugin.
     * </p>
     * 
     * @return The ID of the plugin.
     */
    public final String pluginId() {
        return pluginId;
    }

    /**
     * <p>
     * The name of the host.
     * </p>
     * 
     * @return The name of the host.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The status of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PluginHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the plugin.
     * @see PluginHealth
     */
    public final PluginHealth status() {
        return PluginHealth.fromValue(status);
    }

    /**
     * <p>
     * The status of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PluginHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the plugin.
     * @see PluginHealth
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The IP address at which the plugin is located.
     * </p>
     * 
     * @return The IP address at which the plugin is located.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The version of the plugin.
     * </p>
     * 
     * @return The version of the plugin.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The time at which the plugin was registered.
     * </p>
     * 
     * @return The time at which the plugin was registered.
     */
    public final String registeredTime() {
        return registeredTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(registeredTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginSummary)) {
            return false;
        }
        PluginSummary other = (PluginSummary) obj;
        return Objects.equals(pluginId(), other.pluginId()) && Objects.equals(hostname(), other.hostname())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(version(), other.version()) && Objects.equals(registeredTime(), other.registeredTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PluginSummary").add("PluginId", pluginId()).add("Hostname", hostname())
                .add("Status", statusAsString()).add("IpAddress", ipAddress()).add("Version", version())
                .add("RegisteredTime", registeredTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pluginId":
            return Optional.ofNullable(clazz.cast(pluginId()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ipAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "registeredTime":
            return Optional.ofNullable(clazz.cast(registeredTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("registeredTime", REGISTERED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginSummary, T> g) {
        return obj -> g.apply((PluginSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PluginSummary> {
        /**
         * <p>
         * The ID of the plugin.
         * </p>
         * 
         * @param pluginId
         *        The ID of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginId(String pluginId);

        /**
         * <p>
         * The name of the host.
         * </p>
         * 
         * @param hostname
         *        The name of the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The status of the plugin.
         * </p>
         * 
         * @param status
         *        The status of the plugin.
         * @see PluginHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginHealth
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the plugin.
         * </p>
         * 
         * @param status
         *        The status of the plugin.
         * @see PluginHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginHealth
         */
        Builder status(PluginHealth status);

        /**
         * <p>
         * The IP address at which the plugin is located.
         * </p>
         * 
         * @param ipAddress
         *        The IP address at which the plugin is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The version of the plugin.
         * </p>
         * 
         * @param version
         *        The version of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The time at which the plugin was registered.
         * </p>
         * 
         * @param registeredTime
         *        The time at which the plugin was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredTime(String registeredTime);
    }

    static final class BuilderImpl implements Builder {
        private String pluginId;

        private String hostname;

        private String status;

        private String ipAddress;

        private String version;

        private String registeredTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginSummary model) {
            pluginId(model.pluginId);
            hostname(model.hostname);
            status(model.status);
            ipAddress(model.ipAddress);
            version(model.version);
            registeredTime(model.registeredTime);
        }

        public final String getPluginId() {
            return pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PluginHealth status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getRegisteredTime() {
            return registeredTime;
        }

        public final void setRegisteredTime(String registeredTime) {
            this.registeredTime = registeredTime;
        }

        @Override
        public final Builder registeredTime(String registeredTime) {
            this.registeredTime = registeredTime;
            return this;
        }

        @Override
        public PluginSummary build() {
            return new PluginSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
