/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkflowsResponse extends MigrationHubOrchestratorResponse implements
        ToCopyableBuilder<ListWorkflowsResponse.Builder, ListWorkflowsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorkflowsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<MigrationWorkflowSummary>> MIGRATION_WORKFLOW_SUMMARY_FIELD = SdkField
            .<List<MigrationWorkflowSummary>> builder(MarshallingType.LIST)
            .memberName("migrationWorkflowSummary")
            .getter(getter(ListWorkflowsResponse::migrationWorkflowSummary))
            .setter(setter(Builder::migrationWorkflowSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationWorkflowSummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MigrationWorkflowSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MigrationWorkflowSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MIGRATION_WORKFLOW_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<MigrationWorkflowSummary> migrationWorkflowSummary;

    private ListWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.migrationWorkflowSummary = builder.migrationWorkflowSummary;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MigrationWorkflowSummary property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMigrationWorkflowSummary() {
        return migrationWorkflowSummary != null && !(migrationWorkflowSummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary of the migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMigrationWorkflowSummary} method.
     * </p>
     * 
     * @return The summary of the migration workflow.
     */
    public final List<MigrationWorkflowSummary> migrationWorkflowSummary() {
        return migrationWorkflowSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMigrationWorkflowSummary() ? migrationWorkflowSummary() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowsResponse)) {
            return false;
        }
        ListWorkflowsResponse other = (ListWorkflowsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasMigrationWorkflowSummary() == other.hasMigrationWorkflowSummary()
                && Objects.equals(migrationWorkflowSummary(), other.migrationWorkflowSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkflowsResponse").add("NextToken", nextToken())
                .add("MigrationWorkflowSummary", hasMigrationWorkflowSummary() ? migrationWorkflowSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "migrationWorkflowSummary":
            return Optional.ofNullable(clazz.cast(migrationWorkflowSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("migrationWorkflowSummary", MIGRATION_WORKFLOW_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowsResponse, T> g) {
        return obj -> g.apply((ListWorkflowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubOrchestratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWorkflowsResponse> {
        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The summary of the migration workflow.
         * </p>
         * 
         * @param migrationWorkflowSummary
         *        The summary of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationWorkflowSummary(Collection<MigrationWorkflowSummary> migrationWorkflowSummary);

        /**
         * <p>
         * The summary of the migration workflow.
         * </p>
         * 
         * @param migrationWorkflowSummary
         *        The summary of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationWorkflowSummary(MigrationWorkflowSummary... migrationWorkflowSummary);

        /**
         * <p>
         * The summary of the migration workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #migrationWorkflowSummary(List<MigrationWorkflowSummary>)}.
         * 
         * @param migrationWorkflowSummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #migrationWorkflowSummary(java.util.Collection<MigrationWorkflowSummary>)
         */
        Builder migrationWorkflowSummary(Consumer<MigrationWorkflowSummary.Builder>... migrationWorkflowSummary);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MigrationWorkflowSummary> migrationWorkflowSummary = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowsResponse model) {
            super(model);
            nextToken(model.nextToken);
            migrationWorkflowSummary(model.migrationWorkflowSummary);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MigrationWorkflowSummary.Builder> getMigrationWorkflowSummary() {
            List<MigrationWorkflowSummary.Builder> result = MigrationWorkflowSummaryListCopier
                    .copyToBuilder(this.migrationWorkflowSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMigrationWorkflowSummary(Collection<MigrationWorkflowSummary.BuilderImpl> migrationWorkflowSummary) {
            this.migrationWorkflowSummary = MigrationWorkflowSummaryListCopier.copyFromBuilder(migrationWorkflowSummary);
        }

        @Override
        public final Builder migrationWorkflowSummary(Collection<MigrationWorkflowSummary> migrationWorkflowSummary) {
            this.migrationWorkflowSummary = MigrationWorkflowSummaryListCopier.copy(migrationWorkflowSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationWorkflowSummary(MigrationWorkflowSummary... migrationWorkflowSummary) {
            migrationWorkflowSummary(Arrays.asList(migrationWorkflowSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder migrationWorkflowSummary(Consumer<MigrationWorkflowSummary.Builder>... migrationWorkflowSummary) {
            migrationWorkflowSummary(Stream.of(migrationWorkflowSummary)
                    .map(c -> MigrationWorkflowSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkflowsResponse build() {
            return new ListWorkflowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
