/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhuborchestrator.model.DataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepOutput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StepOutput.getter(StepOutput::name)).setter(StepOutput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(StepOutput.getter(StepOutput::dataTypeAsString)).setter(StepOutput.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("required").getter(StepOutput.getter(StepOutput::required)).setter(StepOutput.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_TYPE_FIELD, REQUIRED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StepOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String dataType;
    private final Boolean required;

    private StepOutput(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.required = builder.required;
    }

    public final String name() {
        return this.name;
    }

    public final DataType dataType() {
        return DataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final Boolean required() {
        return this.required;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepOutput)) {
            return false;
        }
        StepOutput other = (StepOutput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.required(), other.required());
    }

    public final String toString() {
        return ToString.builder((String)"StepOutput").add("Name", (Object)this.name()).add("DataType", (Object)this.dataTypeAsString()).add("Required", (Object)this.required()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("required", REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepOutput, T> g) {
        return obj -> g.apply((StepOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String dataType;
        private Boolean required;

        private BuilderImpl() {
        }

        private BuilderImpl(StepOutput model) {
            this.name(model.name);
            this.dataType(model.dataType);
            this.required(model.required);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public StepOutput build() {
            return new StepOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepOutput> {
        public Builder name(String var1);

        public Builder dataType(String var1);

        public Builder dataType(DataType var1);

        public Builder required(Boolean var1);
    }
}

