/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepInput;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepInputParametersCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowRequest
extends MigrationHubOrchestratorRequest
implements ToCopyableBuilder<Builder, CreateWorkflowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::name)).setter(CreateWorkflowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::description)).setter(CreateWorkflowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateId").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::templateId)).setter(CreateWorkflowRequest.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final SdkField<String> APPLICATION_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationConfigurationId").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::applicationConfigurationId)).setter(CreateWorkflowRequest.setter(Builder::applicationConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationConfigurationId").build()}).build();
    private static final SdkField<Map<String, StepInput>> INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("inputParameters").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::inputParameters)).setter(CreateWorkflowRequest.setter(Builder::inputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STEP_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stepTargets").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::stepTargets)).setter(CreateWorkflowRequest.setter(Builder::stepTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::tags)).setter(CreateWorkflowRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_ID_FIELD, APPLICATION_CONFIGURATION_ID_FIELD, INPUT_PARAMETERS_FIELD, STEP_TARGETS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkflowRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String templateId;
    private final String applicationConfigurationId;
    private final Map<String, StepInput> inputParameters;
    private final List<String> stepTargets;
    private final Map<String, String> tags;

    private CreateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.applicationConfigurationId = builder.applicationConfigurationId;
        this.inputParameters = builder.inputParameters;
        this.stepTargets = builder.stepTargets;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String applicationConfigurationId() {
        return this.applicationConfigurationId;
    }

    public final boolean hasInputParameters() {
        return this.inputParameters != null && !(this.inputParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, StepInput> inputParameters() {
        return this.inputParameters;
    }

    public final boolean hasStepTargets() {
        return this.stepTargets != null && !(this.stepTargets instanceof SdkAutoConstructList);
    }

    public final List<String> stepTargets() {
        return this.stepTargets;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputParameters() ? this.inputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepTargets() ? this.stepTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.applicationConfigurationId(), other.applicationConfigurationId()) && this.hasInputParameters() == other.hasInputParameters() && Objects.equals(this.inputParameters(), other.inputParameters()) && this.hasStepTargets() == other.hasStepTargets() && Objects.equals(this.stepTargets(), other.stepTargets()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TemplateId", (Object)this.templateId()).add("ApplicationConfigurationId", (Object)this.applicationConfigurationId()).add("InputParameters", (Object)(this.inputParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("StepTargets", this.hasStepTargets() ? this.stepTargets() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "templateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "applicationConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.applicationConfigurationId()));
            }
            case "inputParameters": {
                return Optional.ofNullable(clazz.cast(this.inputParameters()));
            }
            case "stepTargets": {
                return Optional.ofNullable(clazz.cast(this.stepTargets()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("applicationConfigurationId", APPLICATION_CONFIGURATION_ID_FIELD);
        map.put("inputParameters", INPUT_PARAMETERS_FIELD);
        map.put("stepTargets", STEP_TARGETS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowRequest, T> g) {
        return obj -> g.apply((CreateWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String templateId;
        private String applicationConfigurationId;
        private Map<String, StepInput> inputParameters = DefaultSdkAutoConstructMap.getInstance();
        private List<String> stepTargets = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.templateId(model.templateId);
            this.applicationConfigurationId(model.applicationConfigurationId);
            this.inputParameters(model.inputParameters);
            this.stepTargets(model.stepTargets);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getApplicationConfigurationId() {
            return this.applicationConfigurationId;
        }

        public final void setApplicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
        }

        @Override
        public final Builder applicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
            return this;
        }

        public final Map<String, StepInput.Builder> getInputParameters() {
            Map<String, StepInput.Builder> result = StepInputParametersCopier.copyToBuilder(this.inputParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputParameters(Map<String, StepInput.BuilderImpl> inputParameters) {
            this.inputParameters = StepInputParametersCopier.copyFromBuilder(inputParameters);
        }

        @Override
        public final Builder inputParameters(Map<String, StepInput> inputParameters) {
            this.inputParameters = StepInputParametersCopier.copy(inputParameters);
            return this;
        }

        public final Collection<String> getStepTargets() {
            if (this.stepTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stepTargets;
        }

        public final void setStepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
        }

        @Override
        public final Builder stepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepTargets(String ... stepTargets) {
            this.stepTargets(Arrays.asList(stepTargets));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowRequest build() {
            return new CreateWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder templateId(String var1);

        public Builder applicationConfigurationId(String var1);

        public Builder inputParameters(Map<String, StepInput> var1);

        public Builder stepTargets(Collection<String> var1);

        public Builder stepTargets(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

