/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepSummary;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTemplateStepsResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, ListTemplateStepsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTemplateStepsResponse.getter(ListTemplateStepsResponse::nextToken)).setter(ListTemplateStepsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TemplateStepSummary>> TEMPLATE_STEP_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templateStepSummaryList").getter(ListTemplateStepsResponse.getter(ListTemplateStepsResponse::templateStepSummaryList)).setter(ListTemplateStepsResponse.setter(Builder::templateStepSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateStepSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateStepSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TEMPLATE_STEP_SUMMARY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("templateStepSummaryList", TEMPLATE_STEP_SUMMARY_LIST_FIELD);
        }
    });
    private final String nextToken;
    private final List<TemplateStepSummary> templateStepSummaryList;

    private ListTemplateStepsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templateStepSummaryList = builder.templateStepSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTemplateStepSummaryList() {
        return this.templateStepSummaryList != null && !(this.templateStepSummaryList instanceof SdkAutoConstructList);
    }

    public final List<TemplateStepSummary> templateStepSummaryList() {
        return this.templateStepSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateStepSummaryList() ? this.templateStepSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateStepsResponse)) {
            return false;
        }
        ListTemplateStepsResponse other = (ListTemplateStepsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTemplateStepSummaryList() == other.hasTemplateStepSummaryList() && Objects.equals(this.templateStepSummaryList(), other.templateStepSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListTemplateStepsResponse").add("NextToken", (Object)this.nextToken()).add("TemplateStepSummaryList", this.hasTemplateStepSummaryList() ? this.templateStepSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "templateStepSummaryList": {
                return Optional.ofNullable(clazz.cast(this.templateStepSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateStepsResponse, T> g) {
        return obj -> g.apply((ListTemplateStepsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TemplateStepSummary> templateStepSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateStepsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.templateStepSummaryList(model.templateStepSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TemplateStepSummary.Builder> getTemplateStepSummaryList() {
            List<TemplateStepSummary.Builder> result = TemplateStepSummaryListCopier.copyToBuilder(this.templateStepSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateStepSummaryList(Collection<TemplateStepSummary.BuilderImpl> templateStepSummaryList) {
            this.templateStepSummaryList = TemplateStepSummaryListCopier.copyFromBuilder(templateStepSummaryList);
        }

        @Override
        public final Builder templateStepSummaryList(Collection<TemplateStepSummary> templateStepSummaryList) {
            this.templateStepSummaryList = TemplateStepSummaryListCopier.copy(templateStepSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateStepSummaryList(TemplateStepSummary ... templateStepSummaryList) {
            this.templateStepSummaryList(Arrays.asList(templateStepSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateStepSummaryList(Consumer<TemplateStepSummary.Builder> ... templateStepSummaryList) {
            this.templateStepSummaryList(Stream.of(templateStepSummaryList).map(c -> (TemplateStepSummary)((TemplateStepSummary.Builder)TemplateStepSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTemplateStepsResponse build() {
            return new ListTemplateStepsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTemplateStepsResponse> {
        public Builder nextToken(String var1);

        public Builder templateStepSummaryList(Collection<TemplateStepSummary> var1);

        public Builder templateStepSummaryList(TemplateStepSummary ... var1);

        public Builder templateStepSummaryList(Consumer<TemplateStepSummary.Builder> ... var1);
    }
}

