/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlatformCommand
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlatformCommand> {
    private static final SdkField<String> LINUX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("linux").getter(PlatformCommand.getter(PlatformCommand::linux)).setter(PlatformCommand.setter(Builder::linux)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linux").build()}).build();
    private static final SdkField<String> WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("windows").getter(PlatformCommand.getter(PlatformCommand::windows)).setter(PlatformCommand.setter(Builder::windows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("windows").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINUX_FIELD, WINDOWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("linux", LINUX_FIELD);
            this.put("windows", WINDOWS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String linux;
    private final String windows;

    private PlatformCommand(BuilderImpl builder) {
        this.linux = builder.linux;
        this.windows = builder.windows;
    }

    public final String linux() {
        return this.linux;
    }

    public final String windows() {
        return this.windows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.linux());
        hashCode = 31 * hashCode + Objects.hashCode(this.windows());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformCommand)) {
            return false;
        }
        PlatformCommand other = (PlatformCommand)obj;
        return Objects.equals(this.linux(), other.linux()) && Objects.equals(this.windows(), other.windows());
    }

    public final String toString() {
        return ToString.builder((String)"PlatformCommand").add("Linux", (Object)this.linux()).add("Windows", (Object)this.windows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "linux": {
                return Optional.ofNullable(clazz.cast(this.linux()));
            }
            case "windows": {
                return Optional.ofNullable(clazz.cast(this.windows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PlatformCommand, T> g) {
        return obj -> g.apply((PlatformCommand)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String linux;
        private String windows;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformCommand model) {
            this.linux(model.linux);
            this.windows(model.windows);
        }

        public final String getLinux() {
            return this.linux;
        }

        public final void setLinux(String linux) {
            this.linux = linux;
        }

        @Override
        public final Builder linux(String linux) {
            this.linux = linux;
            return this;
        }

        public final String getWindows() {
            return this.windows;
        }

        public final void setWindows(String windows) {
            this.windows = windows;
        }

        @Override
        public final Builder windows(String windows) {
            this.windows = windows;
            return this;
        }

        public PlatformCommand build() {
            return new PlatformCommand(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlatformCommand> {
        public Builder linux(String var1);

        public Builder windows(String var1);
    }
}

