/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorClient;
import software.amazon.awssdk.services.migrationhuborchestrator.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary;

public class ListTemplatesIterable
implements SdkIterable<ListTemplatesResponse> {
    private final MigrationHubOrchestratorClient client;
    private final ListTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplatesIterable(MigrationHubOrchestratorClient client, ListTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTemplatesResponseFetcher();
    }

    public Iterator<ListTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateSummary> templateSummary() {
        Function<ListTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateSummary() != null) {
                return response.templateSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTemplatesResponseFetcher
    implements SyncPageFetcher<ListTemplatesResponse> {
        private ListTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplatesResponse nextPage(ListTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplatesIterable.this.client.listTemplates(ListTemplatesIterable.this.firstRequest);
            }
            return ListTemplatesIterable.this.client.listTemplates((ListTemplatesRequest)((Object)ListTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

