/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkflowStepGroupRequest extends MigrationHubOrchestratorRequest implements
        ToCopyableBuilder<CreateWorkflowStepGroupRequest.Builder, CreateWorkflowStepGroupRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(CreateWorkflowStepGroupRequest::workflowId))
            .setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkflowStepGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateWorkflowStepGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> NEXT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("next")
            .getter(getter(CreateWorkflowStepGroupRequest::next))
            .setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("previous")
            .getter(getter(CreateWorkflowStepGroupRequest::previous))
            .setter(setter(Builder::previous))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, NEXT_FIELD, PREVIOUS_FIELD));

    private final String workflowId;

    private final String name;

    private final String description;

    private final List<String> next;

    private final List<String> previous;

    private CreateWorkflowStepGroupRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.name = builder.name;
        this.description = builder.description;
        this.next = builder.next;
        this.previous = builder.previous;
    }

    /**
     * <p>
     * The ID of the migration workflow that will contain the step group.
     * </p>
     * 
     * @return The ID of the migration workflow that will contain the step group.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The name of the step group.
     * </p>
     * 
     * @return The name of the step group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the step group.
     * </p>
     * 
     * @return The description of the step group.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Next property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNext() {
        return next != null && !(next instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The next step group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNext} method.
     * </p>
     * 
     * @return The next step group.
     */
    public final List<String> next() {
        return next;
    }

    /**
     * For responses, this returns true if the service returned a value for the Previous property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrevious() {
        return previous != null && !(previous instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The previous step group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrevious} method.
     * </p>
     * 
     * @return The previous step group.
     */
    public final List<String> previous() {
        return previous;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasNext() ? next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrevious() ? previous() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowStepGroupRequest)) {
            return false;
        }
        CreateWorkflowStepGroupRequest other = (CreateWorkflowStepGroupRequest) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasNext() == other.hasNext()
                && Objects.equals(next(), other.next()) && hasPrevious() == other.hasPrevious()
                && Objects.equals(previous(), other.previous());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkflowStepGroupRequest").add("WorkflowId", workflowId()).add("Name", name())
                .add("Description", description()).add("Next", hasNext() ? next() : null)
                .add("Previous", hasPrevious() ? previous() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        case "previous":
            return Optional.ofNullable(clazz.cast(previous()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowStepGroupRequest, T> g) {
        return obj -> g.apply((CreateWorkflowStepGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubOrchestratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkflowStepGroupRequest> {
        /**
         * <p>
         * The ID of the migration workflow that will contain the step group.
         * </p>
         * 
         * @param workflowId
         *        The ID of the migration workflow that will contain the step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The name of the step group.
         * </p>
         * 
         * @param name
         *        The name of the step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the step group.
         * </p>
         * 
         * @param description
         *        The description of the step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The next step group.
         * </p>
         * 
         * @param next
         *        The next step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(Collection<String> next);

        /**
         * <p>
         * The next step group.
         * </p>
         * 
         * @param next
         *        The next step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String... next);

        /**
         * <p>
         * The previous step group.
         * </p>
         * 
         * @param previous
         *        The previous step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(Collection<String> previous);

        /**
         * <p>
         * The previous step group.
         * </p>
         * 
         * @param previous
         *        The previous step group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previous(String... previous);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorRequest.BuilderImpl implements Builder {
        private String workflowId;

        private String name;

        private String description;

        private List<String> next = DefaultSdkAutoConstructList.getInstance();

        private List<String> previous = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowStepGroupRequest model) {
            super(model);
            workflowId(model.workflowId);
            name(model.name);
            description(model.description);
            next(model.next);
            previous(model.previous);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getNext() {
            if (next instanceof SdkAutoConstructList) {
                return null;
            }
            return next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String... next) {
            next(Arrays.asList(next));
            return this;
        }

        public final Collection<String> getPrevious() {
            if (previous instanceof SdkAutoConstructList) {
                return null;
            }
            return previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String... previous) {
            previous(Arrays.asList(previous));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowStepGroupRequest build() {
            return new CreateWorkflowStepGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
